/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher.ui.launchbar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.launchbar.core.AbstractLaunchConfigProvider;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class CoreBuildContainerLaunchConfigProvider
extends AbstractLaunchConfigProvider {
    private static final String TYPE_ID = "org.eclipse.cdt.docker.launcher.launchConfigurationType";
    private Map<IProject, Map<String, ILaunchConfiguration>> configs = new HashMap<IProject, Map<String, ILaunchConfiguration>>();

    public boolean supports(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return target != null && "org.eclipse.cdt.docker.launcher.launchTargetType.container".equals(target.getTypeId());
    }

    public ILaunchConfigurationType getLaunchConfigurationType(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(TYPE_ID);
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target) throws CoreException {
        ILaunchConfiguration config = null;
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null) {
            String imageId;
            String connection;
            String imageName;
            Map<String, ILaunchConfiguration> configMap = this.configs.get(project);
            if (configMap == null) {
                configMap = new HashMap<String, ILaunchConfiguration>();
            }
            if ((config = configMap.get(imageName = (connection = target.getAttribute("connection_uri", "")) + "-" + (imageId = target.getAttribute("image_id", "")))) == null) {
                config = this.createLaunchConfiguration(descriptor, target);
            }
        }
        return config;
    }

    private String getImageName(ILaunchConfiguration config) throws CoreException {
        IProject project = config.getMappedResources()[0].getProject();
        ICBuildConfiguration cconfig = (ICBuildConfiguration)project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class);
        String image = cconfig.getToolChain().getProperty("image_id");
        String connection = cconfig.getToolChain().getProperty("connection_uri");
        Object imageName = "unknown";
        if (connection != null && image != null) {
            imageName = connection + "-" + image;
        }
        return imageName;
    }

    protected void populateLaunchConfiguration(ILaunchDescriptor descriptor, ILaunchTarget target, ILaunchConfigurationWorkingCopy wc) throws CoreException {
        super.populateLaunchConfiguration(descriptor, target, wc);
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        wc.setAttribute("connection_uri", target.getAttribute("connection_uri", null));
        wc.setAttribute("image_id", target.getAttribute("image_id", null));
        IPreferenceStore preferenceStore = GdbUIPlugin.getDefault().getPreferenceStore();
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", preferenceStore.getString("defaultGdbCommand"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", preferenceStore.getString("defaultGdbInit"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", preferenceStore.getBoolean("defaultNonStop"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_ON_FORK", false);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.TRACEPOINT_MODE", "TP_NORMAL_ONLY");
        wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        wc.setMappedResources(new IResource[]{project});
    }

    public boolean launchConfigurationAdded(ILaunchConfiguration configuration) throws CoreException {
        if (this.ownsLaunchConfiguration(configuration)) {
            String imageName;
            IProject project = configuration.getMappedResources()[0].getProject();
            Map<String, ILaunchConfiguration> configMap = this.configs.get(project);
            if (configMap == null) {
                configMap = new HashMap<String, ILaunchConfiguration>();
                this.configs.put(project, configMap);
            }
            if (!(imageName = this.getImageName(configuration)).equals("-")) {
                configMap.put(imageName, configuration);
            }
            return true;
        }
        return false;
    }

    public boolean launchConfigurationRemoved(ILaunchConfiguration configuration) throws CoreException {
        for (Map.Entry<IProject, Map<String, ILaunchConfiguration>> entry : this.configs.entrySet()) {
            for (Map.Entry<String, ILaunchConfiguration> innerEntry : entry.getValue().entrySet()) {
                if (!configuration.equals(innerEntry.getValue())) continue;
                entry.getValue().remove(innerEntry.getKey());
                return true;
            }
        }
        return false;
    }

    public boolean launchConfigurationChanged(ILaunchConfiguration configuration) throws CoreException {
        return false;
    }

    public void launchDescriptorRemoved(ILaunchDescriptor descriptor) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        if (project != null) {
            this.configs.remove(project);
        }
    }

    public void launchTargetRemoved(ILaunchTarget target) throws CoreException {
    }
}

