/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.jface.viewers.TreePath;

public class StandardProcessVMNode
extends AbstractVMNode {
    public StandardProcessVMNode(AbstractVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "StandardProcessVMNode";
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.done();
            } else {
                IProcess[] processes = launch.getProcesses();
                int i = 0;
                while (i < processes.length) {
                    update.setChild((Object)processes[i], i);
                    ++i;
                }
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ILaunch launch = this.findLaunch(update.getElementPath());
                if (launch == null) {
                    assert (false);
                    update.setChildCount(0);
                    update.done();
                    return;
                }
                update.setChildCount(launch.getProcesses().length);
                update.done();
            }
            ++n2;
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.setHasChilren(false);
                update.done();
                return;
            }
            update.setHasChilren(launch.getProcesses().length != 0);
            update.done();
            ++n2;
        }
    }

    public void updateLabel(IVMContext vmc, ILabelRequestMonitor result, String[] columns) {
        assert (false);
        result.done();
    }

    private ILaunch findLaunch(TreePath path) {
        int i = path.getSegmentCount() - 1;
        while (i >= 0) {
            if (path.getSegment(i) instanceof ILaunch) {
                return (ILaunch)path.getSegment(i);
            }
            --i;
        }
        return null;
    }

    @Override
    public int getDeltaFlags(Object e) {
        DebugEvent de;
        int myFlags = 0;
        if (e instanceof DebugEvent && (de = (DebugEvent)e).getSource() instanceof IProcess && (de.getKind() == 16 || de.getKind() == 4 || de.getKind() == 8)) {
            myFlags = 2048;
        }
        return myFlags;
    }

    @Override
    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof DebugEvent && ((DebugEvent)e).getSource() instanceof IProcess) {
            DebugEvent de = (DebugEvent)e;
            if (de.getKind() == 16) {
                this.handleChange(de, parent);
            } else if (de.getKind() == 4) {
                this.handleCreate(de, parent);
            } else if (de.getKind() == 8) {
                this.handleTerminate(de, parent);
            }
        }
        requestMonitor.done();
    }

    protected void handleChange(DebugEvent event, ModelDelta parent) {
        parent.addNode(event.getSource(), 2048);
    }

    protected void handleCreate(DebugEvent event, ModelDelta parent) {
        parent.setFlags(parent.getFlags() | 0x400);
    }

    protected void handleTerminate(DebugEvent event, ModelDelta parent) {
        this.handleChange(event, parent);
    }
}

