/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.ui;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.FileMacroExplicitSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class GnuAsmFlagsCommandGenerator
implements IOptionCommandGenerator {
    private static final String DO_NOT_LINK_FLAG = "-c";
    private static final Pattern DO_NOT_LINK_PATTERN = Pattern.compile("(^|\\s)-c($|\\s)");
    private static final Pattern ASM_FLAG_PATTERN = Pattern.compile("(?<=^|\\s)-[aDKLR]\\S*");

    public String generateCommand(IOption option, IVariableSubstitutor macroSubstitutor) {
        String toolCommand = GnuAsmFlagsCommandGenerator.getToolCommand(option, macroSubstitutor);
        try {
            if (toolCommand != null && 2 == option.getValueType() && option.getCommand().isEmpty()) {
                String optionValue = option.getStringValue();
                if (toolCommand.equals("gcc")) {
                    String command = CdtVariableResolver.resolveToString((String)optionValue, (IVariableSubstitutor)macroSubstitutor);
                    if (!DO_NOT_LINK_PATTERN.matcher(command).find()) {
                        return "-c " + ASM_FLAG_PATTERN.matcher(command).replaceAll("-Wa,$0");
                    }
                } else if (toolCommand.endsWith("as") && optionValue.equals(DO_NOT_LINK_FLAG)) {
                    return "";
                }
            }
        }
        catch (CdtVariableException | BuildException e) {
            Platform.getLog(this.getClass()).log(Status.error((String)"Error generating GNU assembler command", (Throwable)e));
        }
        return null;
    }

    private static String getToolCommand(IOption option, IVariableSubstitutor macroSubstitutor) {
        String optionHolderId;
        ITool[] tools;
        IConfiguration config = GnuAsmFlagsCommandGenerator.getConfiguration(macroSubstitutor);
        if (config != null && 1 == (tools = config.getToolsBySuperClassId(optionHolderId = option.getOptionHolder().getId())).length) {
            return tools[0].getToolCommand();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static IConfiguration getConfiguration(IVariableSubstitutor macroSubstitutor) {
        IVariableSubstitutor iVariableSubstitutor = macroSubstitutor;
        if (iVariableSubstitutor instanceof BuildfileMacroSubstitutor) {
            void bms;
            BuildfileMacroSubstitutor buildfileMacroSubstitutor = (BuildfileMacroSubstitutor)iVariableSubstitutor;
            BuildfileMacroSubstitutor cfr_ignored_0 = (BuildfileMacroSubstitutor)iVariableSubstitutor;
            return bms.getConfiguration();
        }
        IVariableSubstitutor iVariableSubstitutor2 = macroSubstitutor;
        if (iVariableSubstitutor2 instanceof FileMacroExplicitSubstitutor) {
            void fmes;
            FileMacroExplicitSubstitutor fileMacroExplicitSubstitutor = (FileMacroExplicitSubstitutor)iVariableSubstitutor2;
            FileMacroExplicitSubstitutor cfr_ignored_1 = (FileMacroExplicitSubstitutor)iVariableSubstitutor2;
            return fmes.getConfiguration();
        }
        return null;
    }
}

