/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.net.URI;
import java.net.URL;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleMessages;
import org.eclipse.cdt.internal.ui.buildconsole.GlobalBuildConsole;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public class GlobalBuildConsoleManager
extends BuildConsoleManager {
    private static final String GLOBAL_BUILD_CONSOLE_NODE = "globalBuildConsole";
    private static final String GLOBAL_LOG_FILE = "global-build.log";
    private static final String GLOBAL_CONTEXT_MENU_ID = "org.eclipse.cdt.ui.CDTGlobalBuildConsole";
    private static GlobalBuildConsoleManager INSTANCE = null;
    private static BuildConsolePartitioner fGlobalConsolePartitioner = null;

    private GlobalBuildConsoleManager() {
        this.startup(ConsoleMessages.BuildConsole_GlobalConsole, GLOBAL_CONTEXT_MENU_ID, null);
    }

    private static GlobalBuildConsoleManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlobalBuildConsoleManager();
        }
        return INSTANCE;
    }

    private static BuildConsolePartitioner getConsolePartitioner() {
        if (fGlobalConsolePartitioner == null) {
            fGlobalConsolePartitioner = new BuildConsolePartitioner(GlobalBuildConsoleManager.getInstance());
        }
        return fGlobalConsolePartitioner;
    }

    public static void startup() {
        GlobalBuildConsoleManager.getInstance();
    }

    static void staticReinitaliazeIfNecessary() {
        GlobalBuildConsoleManager.getInstance().reinitaliazeIfNecessary();
    }

    public static void stop() {
        if (INSTANCE != null) {
            INSTANCE.shutdown();
        }
    }

    @Override
    protected BuildConsole createBuildConsole(String name, String contextId, URL iconUrl) {
        return new GlobalBuildConsole(this, name, contextId, iconUrl);
    }

    public static IConsole getGlobalConsole() {
        return GlobalBuildConsoleManager.getConsolePartitioner().getConsole();
    }

    public static void startGlobalConsole() {
        if (BuildConsolePreferencePage.isClearBuildConsole()) {
            GlobalBuildConsoleManager.getConsolePartitioner().appendToDocument("", null, null);
        }
        GlobalBuildConsoleManager.getConsolePartitioner().setStreamOpened();
    }

    public static void stopGlobalConsole() {
    }

    public static IPreferenceStore getBuildLogPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.cdt.ui/globalBuildConsole");
    }

    public static Preferences getBuildLogPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.ui").node(GLOBAL_BUILD_CONSOLE_NODE);
    }

    public static String getDefaultConsoleLogLocation() {
        IPath defaultLogLocation = CUIPlugin.getDefault().getStateLocation().append(GLOBAL_LOG_FILE);
        return defaultLogLocation.toOSString();
    }

    @Override
    public IConsole getConsole(IProject project) {
        return GlobalBuildConsoleManager.getGlobalConsole();
    }

    @Override
    public IConsole getProjectConsole(IProject project) {
        return GlobalBuildConsoleManager.getGlobalConsole();
    }

    @Override
    public IDocument getConsoleDocument(IProject project) {
        return GlobalBuildConsoleManager.getConsolePartitioner().getDocument();
    }

    @Override
    public IProject getLastBuiltProject() {
        return null;
    }

    @Override
    public URI getLogURI(IProject project) {
        URI logURI = null;
        Preferences prefs = GlobalBuildConsoleManager.getBuildLogPreferences();
        boolean keepLog = prefs.getBoolean("keepLog", true);
        if (keepLog) {
            String strLocation = prefs.get("logLocation", GlobalBuildConsoleManager.getDefaultConsoleLogLocation());
            if (strLocation.trim().length() > 0) {
                logURI = URIUtil.toURI((String)strLocation);
            }
            if (logURI == null) {
                Status status = new Status(4, "org.eclipse.cdt.ui", "Can't determine URI for location=[" + strLocation + "]");
                CUIPlugin.log((IStatus)status);
            }
        }
        return logURI;
    }
}

