/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.pda.launch.PDALaunch;
import org.eclipse.cdt.examples.dsf.pda.ui.SessionAdapterSet;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PDAUIPlugin
extends AbstractUIPlugin
implements ILaunchesListener2 {
    public static String PLUGIN_ID = "org.eclipse.cdt.examples.dsf.pda.ui ";
    private static PDAUIPlugin plugin;
    private static BundleContext fContext;
    private static final String ICONS_PATH = "icons/full/";
    private static final String PATH_OBJECT = "icons/full/obj16/";
    public static final String IMG_OBJ_PDA = "IMB_OBJ_PDA";
    public static final RGB KEYWORD;
    public static final RGB LABEL;
    private Map<RGB, Color> fColors = new HashMap<RGB, Color>();
    private Map<String, SessionAdapterSet> fSessionAdapterSets = Collections.synchronizedMap(new HashMap());
    private Map<ILaunch, Object> fDisposedSessionAdapterSets = new WeakHashMap<ILaunch, Object>();

    static {
        KEYWORD = new RGB(0, 0, 255);
        LABEL = new RGB(128, 128, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAdapterSet(PDALaunch launch) {
        String sessionId = launch.getSession().getId();
        Map<String, SessionAdapterSet> map = this.fSessionAdapterSets;
        synchronized (map) {
            if (this.fSessionAdapterSets.containsKey(sessionId)) {
                this.fSessionAdapterSets.remove(sessionId).dispose();
                this.fDisposedSessionAdapterSets.put((ILaunch)launch, null);
            }
        }
    }

    public PDAUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        fContext = context;
        super.start(context);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        this.disposeAdapterSets();
        super.stop(context);
        plugin = null;
        fContext = null;
        for (Map.Entry<RGB, Color> entry : this.fColors.entrySet()) {
            entry.getValue().dispose();
        }
    }

    public static PDAUIPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fContext;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.declareImage(IMG_OBJ_PDA, "icons/full/obj16/pda.gif");
    }

    private void declareImage(String key, String path) {
        URL url = BundleUtility.find((String)"org.eclipse.cdt.examples.dsf.pda.ui", (String)path);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getImageRegistry().put(key, desc);
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColors.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColors.put(rgb, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionAdapterSet getAdapterSet(PDALaunch launch) {
        SessionAdapterSet adapterSet;
        Map<String, SessionAdapterSet> map = this.fSessionAdapterSets;
        synchronized (map) {
            block5: {
                if (!this.fDisposedSessionAdapterSets.containsKey(launch)) break block5;
                return null;
            }
            String sessionId = launch.getSession().getId();
            adapterSet = this.fSessionAdapterSets.get(sessionId);
            if (adapterSet == null) {
                adapterSet = new SessionAdapterSet(launch);
                this.fSessionAdapterSets.put(sessionId, adapterSet);
            }
        }
        return adapterSet;
    }

    SessionAdapterSet getAdapterSet(String sessionId) {
        DsfSession session = DsfSession.getSession((String)sessionId);
        ILaunch launch = (ILaunch)session.getModelAdapter(ILaunch.class);
        if (launch instanceof PDALaunch) {
            return this.getAdapterSet((PDALaunch)launch);
        }
        return null;
    }

    private void disposeAdapterSets() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof PDALaunch) {
                this.disposeAdapterSet((PDALaunch)launch);
            }
            ++n2;
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof PDALaunch) {
                this.disposeAdapterSet((PDALaunch)launch);
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }
}

