/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.pda.ui.editor;

import org.eclipse.cdt.examples.dsf.pda.ui.PDAUIPlugin;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class PDAScanner
extends BufferedRuleBasedScanner {
    public static final String[] fgKeywords = new String[]{"add", "branch_not_zero", "call", "dec", "dup", "halt", "output", "pop", "push", "return", "var"};

    public PDAScanner() {
        Token token = new Token((Object)new TextAttribute(PDAUIPlugin.getDefault().getColor(PDAUIPlugin.KEYWORD)));
        WordRule keywords = new WordRule((IWordDetector)new PDAWordDetector());
        int i = 0;
        while (i < fgKeywords.length) {
            String keyword = fgKeywords[i];
            keywords.addWord(keyword, (IToken)token);
            ++i;
        }
        token = new Token((Object)new TextAttribute(PDAUIPlugin.getDefault().getColor(PDAUIPlugin.LABEL)));
        WordRule labels = new WordRule((IWordDetector)new PDALabelDetector(), (IToken)token);
        this.setRules(new IRule[]{keywords, labels});
    }

    class PDALabelDetector
    extends PDAWordDetector {
        PDALabelDetector() {
        }

        @Override
        public boolean isWordStart(char c) {
            return c == ':';
        }

        @Override
        public boolean isWordPart(char c) {
            return super.isWordPart(c) || Character.isDigit(c);
        }
    }

    class PDAWordDetector
    implements IWordDetector {
        PDAWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c) || c == '_';
        }
    }
}

