/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.AlarmService;
import org.eclipse.cdt.examples.dsf.timers.TimerService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;

class AlarmsVMNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public AlarmsVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, AlarmService.AlarmDMContext.class);
    }

    public String toString() {
        return "AlarmsVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        AlarmService alarmService = (AlarmService)((Object)this.getServicesTracker().getService(AlarmService.class, null));
        AlarmService.TriggerDMContext alarmDmc = (AlarmService.TriggerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), AlarmService.TriggerDMContext.class);
        TimerService.TimerDMContext timerDmc = (TimerService.TimerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), TimerService.TimerDMContext.class);
        if (alarmService == null || alarmDmc == null || timerDmc == null) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Required elements not found in path"));
            update.done();
            return;
        }
        AlarmService.AlarmDMContext alarmStatusDmc = alarmService.getAlarm(alarmDmc, timerDmc);
        boolean triggered = alarmService.isAlarmTriggered(alarmStatusDmc);
        if (triggered) {
            update.setChild((Object)this.createVMContext((IDMContext)alarmStatusDmc), 0);
        }
        update.done();
    }

    public void update(ILabelUpdate[] updates) {
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            update.setLabel("ALARM TRIGGERED", 0);
            update.setImageDescriptor(DsfExamplesPlugin.getDefault().getImageRegistry().getDescriptor("icons/alarm_triggered.gif"), 0);
            update.done();
            ++n2;
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof AlarmService.AlarmTriggeredDMEvent) {
            return 0x300001;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof AlarmService.AlarmTriggeredDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x100000);
            parentDelta.addNode((Object)this.createVMContext(((AlarmService.AlarmTriggeredDMEvent)((Object)e)).getDMContext()), 0, 0x200001);
        }
        requestMonitor.done();
    }
}

