/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameConfigurationDialog
extends Dialog {
    private Text configName;
    private Text configDescription;
    private ICConfigurationDescription[] cfgds;
    private ICConfigurationDescription renameConfig;
    private String newName;
    private String newDescription;
    private Label statusLabel;
    private String originalName;
    private final String title;

    protected RenameConfigurationDialog(Shell parentShell, ICConfigurationDescription _renameConfig, ICConfigurationDescription[] _cfgds, String _title) {
        super(parentShell);
        this.title = _title;
        this.renameConfig = _renameConfig;
        this.cfgds = _cfgds;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = this.renameConfig.getName();
        this.newDescription = this.renameConfig.getDescription();
        if (this.newDescription == null) {
            this.newDescription = "";
        }
        this.originalName = this.renameConfig.getName();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.newName = this.configName.getText().trim();
            this.newDescription = this.configDescription.getText().trim();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.validateState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Group group1 = new Group(composite, 0);
        group1.setFont(composite.getFont());
        GridLayout layout1 = new GridLayout(3, false);
        group1.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group1.setLayoutData((Object)gd);
        Label warningLabel = new Label((Composite)group1, 65);
        warningLabel.setFont(parent.getFont());
        warningLabel.setText(Messages.RenameConfiguration_label_warning);
        gd = new GridData(4, 1, true, false, 3, 1);
        gd.widthHint = 300;
        warningLabel.setLayoutData((Object)gd);
        Label nameLabel = new Label((Composite)group1, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(Messages.RenameConfiguration_label_name);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text((Composite)group1, 2052);
        this.configName.setFont(group1.getFont());
        this.configName.setText(this.getNewName());
        this.configName.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameConfigurationDialog.this.validateState();
            }
        });
        Label descriptionLabel = new Label((Composite)group1, 16384);
        descriptionLabel.setFont(parent.getFont());
        descriptionLabel.setText(Messages.RenameConfiguration_label_description);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        descriptionLabel.setLayoutData((Object)gd);
        this.configDescription = new Text((Composite)group1, 2052);
        this.configDescription.setFont(group1.getFont());
        this.configDescription.setText(this.getNewDescription());
        this.configDescription.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configDescription.setLayoutData((Object)gd);
        this.statusLabel = new Label(parent, 0x1000000);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.statusLabel.setLayoutData((Object)gd);
        this.statusLabel.setFont(composite.getFont());
        this.statusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
        return composite;
    }

    protected boolean isDuplicateName(String newName) {
        if (newName.equals(this.originalName)) {
            return false;
        }
        int i = 0;
        while (i < this.cfgds.length) {
            if (this.cfgds[i].getName().equals(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSimilarName(String newName) {
        if (newName.equalsIgnoreCase(this.originalName)) {
            return false;
        }
        int i = 0;
        while (i < this.cfgds.length) {
            if (this.cfgds[i].getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean validateName(String name) {
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void validateState() {
        String s = null;
        String currentName = this.configName.getText().trim();
        if (currentName.length() == 0) {
            s = "";
        } else if (this.isDuplicateName(currentName)) {
            s = NLS.bind((String)Messages.RenameConfiguration_error_duplicateName, (Object)currentName);
        } else if (this.isSimilarName(currentName)) {
            s = NLS.bind((String)Messages.RenameConfiguration_error_caseName, (Object)currentName);
        } else if (!this.validateName(currentName)) {
            s = NLS.bind((String)Messages.RenameConfiguration_error_invalidName, (Object)currentName);
        }
        Button b = this.getButton(0);
        if (s != null) {
            this.statusLabel.setText(s);
            this.statusLabel.setVisible(true);
            if (b != null) {
                b.setEnabled(false);
            }
        } else {
            this.statusLabel.setVisible(false);
            if (b != null) {
                b.setEnabled(true);
            }
        }
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewDescription() {
        return this.newDescription;
    }
}

