/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.connections;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ConnectionAndAnchorExample
extends AbstractExample {
    public static void main(String[] args) {
        new ConnectionAndAnchorExample().run();
    }

    @Override
    protected IFigure getContents() {
        Figure panel = new Figure();
        Figure endPointPanel = new Figure();
        endPointPanel.setBounds(new Rectangle(0, 0, 400, 400));
        endPointPanel.setBorder((Border)new GroupBoxBorder("Midpoint Locator"));
        RectangleFigure node1 = new RectangleFigure();
        RectangleFigure node2 = new RectangleFigure();
        node1.setBackgroundColor(ColorConstants.red);
        node1.setBounds(new Rectangle(40, 40, 50, 30));
        node2.setBackgroundColor(ColorConstants.blue);
        node2.setBounds(new Rectangle(200, 40, 50, 30));
        PolylineConnection conn = new PolylineConnection();
        conn.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node1));
        conn.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node2));
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        Label label = new Label("Midpoint");
        label.setOpaque(true);
        label.setBackgroundColor(ColorConstants.buttonLightest);
        label.setBorder((Border)new LineBorder());
        conn.add((IFigure)label, (Object)new MidpointLocator((Connection)conn, 0));
        endPointPanel.add((IFigure)node1);
        endPointPanel.add((IFigure)node2);
        endPointPanel.add((IFigure)conn);
        new Dragger((IFigure)node1);
        new Dragger((IFigure)node2);
        Figure ellipsePanel = new Figure();
        ellipsePanel.setBounds(new Rectangle(420, 0, 400, 400));
        ellipsePanel.setBorder((Border)new GroupBoxBorder("Connection endpoint Locator"));
        RectangleFigure node3 = new RectangleFigure();
        RectangleFigure node4 = new RectangleFigure();
        node3.setBackgroundColor(ColorConstants.green);
        node3.setBounds(new Rectangle(480, 40, 50, 30));
        node4.setBackgroundColor(ColorConstants.black);
        node4.setBounds(new Rectangle(480, 230, 50, 30));
        PolylineConnection conn2 = new PolylineConnection();
        conn2.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node3));
        conn2.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)node4));
        conn2.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        Label endPointLabel = new Label("Endpoint");
        endPointLabel.setOpaque(true);
        endPointLabel.setBackgroundColor(ColorConstants.buttonLightest);
        endPointLabel.setBorder((Border)new LineBorder());
        conn2.add((IFigure)endPointLabel, (Object)new ConnectionEndpointLocator((Connection)conn2, true));
        Label endPointLabel2 = new Label("Endpoint");
        endPointLabel2.setOpaque(true);
        endPointLabel2.setBackgroundColor(ColorConstants.buttonLightest);
        endPointLabel2.setBorder((Border)new LineBorder());
        ConnectionEndpointLocator endpointLocator = new ConnectionEndpointLocator((Connection)conn2, false);
        endpointLocator.setUDistance(4);
        endpointLocator.setVDistance(-3);
        conn2.add((IFigure)endPointLabel2, (Object)endpointLocator);
        Label instructions = new Label(" Drag the shapes to see the Locators in action ");
        instructions.setBorder((Border)new LineBorder());
        instructions.setLocation(new Point(10, 420));
        instructions.setSize(instructions.getPreferredSize());
        ellipsePanel.add((IFigure)node3);
        ellipsePanel.add((IFigure)node4);
        ellipsePanel.add((IFigure)conn2);
        new Dragger((IFigure)node3);
        new Dragger((IFigure)node4);
        panel.add((IFigure)endPointPanel);
        panel.add((IFigure)ellipsePanel);
        panel.add((IFigure)instructions);
        return panel;
    }

    @Override
    protected void hookShell() {
        this.getFigureCanvas().setSize(820, 440);
    }

    static class Dragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        Point last;

        public Dragger(IFigure figure) {
            figure.addMouseMotionListener((MouseMotionListener)this);
            figure.addMouseListener((MouseListener)this);
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDoubleClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.last = e.getLocation();
            e.consume();
        }

        public void mouseDragged(MouseEvent e) {
            Point p = e.getLocation();
            Dimension delta = p.getDifference(this.last);
            this.last = p;
            Figure f = (Figure)e.getSource();
            f.setBounds(f.getBounds().getTranslated(delta.width, delta.height));
        }
    }
}

