/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.path;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class PathFigure
extends Polyline {
    private boolean isClosed;
    private float degrees;
    private float cx;
    private float cy;

    public PathFigure() {
        this.setFill(true);
    }

    protected void outlineShape(Graphics g) {
        this.drawShape(g, false);
    }

    protected void fillShape(Graphics g) {
        this.drawShape(g, true);
    }

    private void drawShape(Graphics g, boolean fill) {
        Path path = this.createPath();
        g.pushState();
        g.setAntialias(1);
        if (fill) {
            g.fillPath(path);
        } else {
            g.drawPath(path);
        }
        g.rotate(this.degrees);
        g.setForegroundColor(ColorConstants.black);
        double angle = PathFigure.degreesToRadians(this.degrees);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        TextLayout textLayout = new TextLayout((Device)Display.getDefault());
        textLayout.setFont(g.getFont());
        textLayout.setText("zoom" + (g instanceof ScaledGraphics ? "[e]" : "[n]"));
        TextStyle textStyle = new TextStyle();
        textStyle.underline = true;
        textStyle.underlineColor = ColorConstants.blue;
        textLayout.setStyle(textStyle, 1, 2);
        PrecisionPoint p = this.getRotatedPoint(this.getBounds().x, this.getBounds().y - 20, cos, sin);
        g.drawTextLayout(textLayout, p.x, p.y, 0, 1, ColorConstants.white, ColorConstants.yellow);
        g.popState();
        path.dispose();
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setRotation(float cx, float cy, float degrees) {
        this.degrees = degrees;
        this.cx = cx;
        this.cy = cy;
        this.bounds = null;
        this.repaint();
    }

    public float getRotationAngle() {
        return this.degrees;
    }

    public Point getRotationCenter() {
        return new PrecisionPoint((double)this.cx, (double)this.cy);
    }

    private Path createPath() {
        PointList points = this.getPoints();
        Path path = new Path((Device)Display.getCurrent());
        double angle = PathFigure.degreesToRadians(this.degrees);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        PrecisionPoint p1 = this.getRotatedPoint(points.getFirstPoint().x(), points.getFirstPoint().y(), cos, sin);
        path.moveTo((float)p1.preciseX(), (float)p1.preciseY());
        int i = 1;
        while (i < points.size()) {
            PrecisionPoint p = this.getRotatedPoint(points.getPoint(i).x(), points.getPoint(i).y(), cos, sin);
            path.lineTo((float)p.preciseX(), (float)p.preciseY());
            ++i;
        }
        if (this.isClosed()) {
            path.close();
        }
        return path;
    }

    public PrecisionPoint getRotatedPoint(float x, float y, double cos, double sin) {
        PrecisionPoint p = new PrecisionPoint((double)x, (double)y);
        if (this.degrees == 0.0f) {
            return p;
        }
        p.setPreciseX(p.preciseX() - (double)this.cx);
        p.setPreciseY(p.preciseY() - (double)this.cy);
        float x1 = (float)(p.preciseX() * cos - p.preciseY() * sin);
        float y1 = (float)(p.preciseY() * cos + p.preciseX() * sin);
        p.setPreciseX((double)(x1 + this.cx));
        p.setPreciseY((double)(y1 + this.cy));
        return p;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle();
            if (this.getPoints().size() > 0) {
                PointList points = this.getPoints();
                double angle = PathFigure.degreesToRadians(this.degrees);
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                PrecisionPoint p1 = this.getRotatedPoint(points.getFirstPoint().x(), points.getFirstPoint().y(), cos, sin);
                this.bounds.setLocation((Point)p1);
                int i = 1;
                while (i < points.size()) {
                    PrecisionPoint p = this.getRotatedPoint(points.getPoint(i).x(), points.getPoint(i).y(), cos, sin);
                    this.bounds.union((Point)p);
                    ++i;
                }
            }
        }
        return this.bounds.getExpanded(this.lineWidth / 2, this.lineWidth / 2);
    }

    private static double degreesToRadians(double angle) {
        return angle * Math.PI / 180.0;
    }
}

