/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class Animation {
    static final long DURATION = 210L;
    static long current;
    static double progress;
    static long start;
    static long finish;
    static Viewport viewport;
    static IFigure trackMe;
    static IFigure showMe;
    static Point trackLocation;
    static boolean PLAYBACK;
    static boolean RECORDING;
    static Map initialStates;
    static Map finalStates;

    static {
        start = -1L;
    }

    static void end() {
        Iterator iter = initialStates.keySet().iterator();
        while (iter.hasNext()) {
            ((IFigure)iter.next()).revalidate();
        }
        initialStates = null;
        finalStates = null;
        PLAYBACK = false;
        trackMe = null;
        showMe = null;
        viewport = null;
    }

    static void mark(IFigure figure) {
        trackMe = figure;
        trackLocation = trackMe.getBounds().getLocation();
        while (!(figure instanceof Viewport)) {
            figure = figure.getParent();
        }
        viewport = (Viewport)figure;
        initialStates = new HashMap();
        finalStates = new HashMap();
        start = System.currentTimeMillis();
        finish = start + 210L;
        current = start + 20L;
    }

    static void captureLayout(IFigure root) {
        RECORDING = true;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        root.validate();
        Iterator iter = initialStates.keySet().iterator();
        while (iter.hasNext()) {
            Animation.recordFinalStates((IFigure)iter.next());
        }
        RECORDING = false;
        PLAYBACK = true;
    }

    static boolean playbackState(IFigure container) {
        if (!PLAYBACK) {
            return false;
        }
        List initial = (List)initialStates.get(container);
        if (initial == null) {
            System.out.println("Error playing back state");
            return false;
        }
        List target = (List)finalStates.get(container);
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Rectangle rect1 = (Rectangle)initial.get(i);
            Rectangle rect2 = (Rectangle)target.get(i);
            child.setBounds(new Rectangle((int)Math.round(progress * (double)rect2.x + (1.0 - progress) * (double)rect1.x), (int)Math.round(progress * (double)rect2.y + (1.0 - progress) * (double)rect1.y), (int)Math.round(progress * (double)rect2.width + (1.0 - progress) * (double)rect1.width), (int)Math.round(progress * (double)rect2.height + (1.0 - progress) * (double)rect1.height)));
            ++i;
        }
        return true;
    }

    static void recordFinalStates(IFigure container) {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        finalStates.put(container, list);
        List children = container.getChildren();
        list.clear();
        int i = 0;
        while (i < children.size()) {
            list.add(((IFigure)children.get(i)).getBounds().getCopy());
            ++i;
        }
    }

    static void recordInitialState(IFigure container) {
        if (!RECORDING) {
            return;
        }
        ArrayList<Rectangle> list = (ArrayList<Rectangle>)initialStates.get(container);
        if (list != null) {
            return;
        }
        list = new ArrayList<Rectangle>();
        initialStates.put(container, list);
        List children = container.getChildren();
        list.clear();
        int i = 0;
        while (i < children.size()) {
            list.add(((IFigure)children.get(i)).getBounds().getCopy());
            ++i;
        }
    }

    static void swap() {
        Map temp = finalStates;
        finalStates = initialStates;
        initialStates = temp;
    }

    static boolean step() {
        current = System.currentTimeMillis() + 30L;
        progress = (double)(current - start) / (double)(finish - start);
        progress = Math.min(progress, 0.999);
        Iterator iter = initialStates.keySet().iterator();
        while (iter.hasNext()) {
            ((IFigure)iter.next()).revalidate();
        }
        viewport.validate();
        Point loc = viewport.getViewLocation();
        loc.translate(trackMe.getBounds().getLocation().getDifference(trackLocation));
        viewport.setViewLocation(loc);
        trackLocation = trackMe.getBounds().getLocation();
        return current < finish;
    }
}

