/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.ExampleTextCommand;

public class NestElementCommand
extends ExampleTextCommand {
    private TextRun run;
    private Container newParent;
    int index;
    private int caretOffset;

    public NestElementCommand(TextEditPart part, int caretOffset) {
        super("indent");
        this.caretOffset = caretOffset;
        this.run = (TextRun)part.getModel();
        this.index = this.run.getContainer().getChildren().indexOf(this.run);
    }

    public void execute() {
        Container container = this.run.getContainer();
        this.newParent = (Container)container.getChildren().get(this.index - 1);
        container.remove(this.run);
        this.run.setType(this.newParent.getChildType());
        this.newParent.add(this.run);
    }

    public boolean canExecute() {
        if (this.index == 0) {
            return false;
        }
        return this.run.getContainer().getChildren().get(this.index - 1) instanceof Container;
    }

    @Override
    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        return new SelectionRange(NestElementCommand.lookupModel(viewer, this.run), this.caretOffset);
    }

    @Override
    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        return this.getExecuteSelectionRange(viewer);
    }

    @Override
    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        return this.getExecuteSelectionRange(viewer);
    }
}

