/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.path;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class ZoomFigure
extends Figure
implements ScalableFigure {
    public static final int NATIVE_SCALING = 0;
    public static final int EMULATED_SCALING = 1;
    private double scale = 1.0;
    private int scaleMethod = 1;

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.scale == 1.0 && this.scaleMethod != 1) {
            super.paintClientArea(graphics);
        } else {
            boolean optimizeClip;
            Graphics g = graphics;
            if (1 == this.scaleMethod) {
                g = new ScaledGraphics(graphics);
            }
            boolean bl = optimizeClip = this.getBorder() == null || this.getBorder().isOpaque();
            if (!optimizeClip) {
                g.clipRect(this.getBounds().getCropped(this.getInsets()));
            }
            g.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
            g.scale(this.scale);
            g.pushState();
            this.paintChildren(g);
            if (1 == this.scaleMethod) {
                g.dispose();
            } else {
                g.popState();
            }
            graphics.restoreState();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.repaint();
    }

    public Rectangle getClientArea(Rectangle rect) {
        super.getClientArea(rect);
        rect.width = (int)((double)rect.width / this.scale);
        rect.height = (int)((double)rect.height / this.scale);
        return rect;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        int w = this.getInsets().getWidth();
        int h = this.getInsets().getHeight();
        return d.getExpanded(-w, -h).scale(this.scale).expand(w, h);
    }

    public void translateToParent(Translatable t) {
        t.performScale(this.scale);
        super.translateToParent(t);
    }

    public void translateFromParent(Translatable t) {
        super.translateFromParent(t);
        t.performScale(1.0 / this.scale);
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void setScaleMethod(int scaleMethod) {
        this.scaleMethod = scaleMethod;
    }
}

