/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.printing;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PrintExample {
    static FigureCanvas canvas;
    static Figure printFigure;
    static Figure internalPrintFigure;
    static int count;

    static {
        count = 1;
    }

    public static void main(String[] args) {
        Display d = Display.getDefault();
        Shell shell = new Shell(d);
        shell.setLayout((Layout)new GridLayout(1, false));
        org.eclipse.swt.widgets.Button printButton = new org.eclipse.swt.widgets.Button((Composite)shell, 8);
        printButton.setText("Print it");
        printButton.setLayoutData((Object)new GridData(32));
        GridData canvasData = new GridData(1808);
        canvasData.horizontalSpan = 2;
        canvas = new FigureCanvas((Composite)shell);
        canvas.setLayoutData((Object)canvasData);
        LightweightSystem lws = new LightweightSystem((Canvas)canvas);
        final Figure printFigure = new Figure();
        printFigure.setMinimumSize(new Dimension(5, 5));
        PrintExample.addAllFigures((IFigure)printFigure);
        lws.setContents((IFigure)printFigure);
        printButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                PrintExample.printIt((IFigure)printFigure);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        shell.setSize(300, 500);
        shell.open();
        while (!shell.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
    }

    static void addAllFigures(IFigure parent) {
        Font[] fonts = new Font[]{new Font(null, "Helvetica", 16, 0), new Font(null, "Times New Roman", 24, 1), new Font(null, "Perpetua", 48, 0)};
        parent.setLayoutManager((LayoutManager)new FlowLayout());
        Button button = new Button("Button");
        RectangleFigure rf = new RectangleFigure();
        rf.setSize(50, 50);
        Ellipse e = new Ellipse();
        e.setSize(50, 50);
        RoundedRectangle rr = new RoundedRectangle();
        rr.setSize(50, 50);
        int i = 0;
        while (i < fonts.length) {
            Label label = new Label(fonts[i].getFontData()[0].getName());
            label.setFont(fonts[i]);
            label.setBorder((Border)new LineBorder());
            parent.add((IFigure)label);
            ++i;
        }
        RectangleFigure rect1 = new RectangleFigure();
        rect1.setSize(50, 50);
        RectangleFigure rect2 = new RectangleFigure();
        rect2.setSize(50, 50);
        PolylineConnection c = new PolylineConnection();
        ChopboxAnchor chop = new ChopboxAnchor((IFigure)rect1);
        c.setSourceAnchor((ConnectionAnchor)chop);
        c.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)rect2));
        Label icon = new Label(new Image(null, PrintExample.class.getResourceAsStream("brazil.ico")));
        parent.add((IFigure)rf);
        parent.add((IFigure)e);
        parent.add((IFigure)rr);
        parent.add((IFigure)button);
        parent.add((IFigure)rect1);
        parent.add((IFigure)rect2);
        parent.add((IFigure)icon);
        parent.add((IFigure)c);
    }

    private static void printIt(IFigure fig) {
        Printer p = new Printer();
        PrintFigureOperation op = new PrintFigureOperation(p, fig);
        op.setPrintMargin(new Insets(0, 0, 0, 0));
        op.run("Test");
        p.dispose();
    }
}

