/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.text;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.examples.text.TestBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CaretExample
extends AbstractExample {
    TextFlow caretOwner;
    TextFlow[] content;
    Caret caret;
    private Label offsetLabel;
    private Label trailLabel;
    private Label charLabel;

    @Override
    protected IFigure getContents() {
        this.caret = new Caret((Canvas)this.getFigureCanvas(), 0);
        final FlowPage page = new FlowPage(){

            protected void paintFigure(Graphics graphics) {
                graphics.setBackgroundColor(new Color(null, 190, 220, 250));
                graphics.fillRectangle(this.getBounds());
            }
        };
        page.setBorder((Border)new LineBorder(ColorConstants.darkGray, 10));
        page.setHorizontalAligment(2);
        final TextFlow text = new TextFlow();
        text.setText("A TextFlow can be queried for an offset for a given Point relative to it. The returned offset will be between 0 and N, where N is the length of the figure's text.\n<Chinese>\u6700\u65b0\u6d88\u606f</Chinese>.\n<Japanese>\u65e5\u672c\u8a9e\u306e\u30da\u30fc\u30b8\u3092\u691c\u7d22</Japanese>.\n<Hebrew>\u05d3\u05e4\u05d9\u05dd\u05b1 \u05de\u05b1- \u05d9\u05e9\u05e8\u05b9\u05b1\u05d0\u05df\u05e5\u05b9\u05b1</Hebrew>\n<Arabic>\u0646\u0635\u064b \u062b\u064f \u0633\u064d\u064e\u0628\u064f\u0633</Arabic>");
        text.setBorder((Border)new TestBorder());
        text.setFont(new Font(null, "Tahoma", 20, 0));
        page.add((IFigure)text);
        page.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent me) {
                int[] trail = new int[1];
                Point where = me.getLocation();
                page.translateFromParent((Translatable)where);
                int offset = text.getOffset(where, trail, null);
                CaretExample.this.showCaret(text, offset, trail);
            }

            public void mouseExited(MouseEvent me) {
            }
        });
        return page;
    }

    @Override
    protected void hookShell() {
        this.getFigureCanvas().addKeyListener((KeyListener)new KeyAdapter(){});
        Group panel = new Group((Composite)this.shell, 0);
        panel.setLayout((Layout)new GridLayout());
        panel.setText("Hit info");
        panel.setLayoutData((Object)new GridData(1040));
        this.offsetLabel = new Label((Composite)panel, 0);
        this.offsetLabel.setText("Offset: 999");
        this.trailLabel = new Label((Composite)panel, 0);
        this.trailLabel.setText("Trail: 0");
        this.charLabel = new Label((Composite)panel, 0);
        this.charLabel.setText("Char: WW");
    }

    void showCaret(TextFlow text, int offset, int[] trailing) {
        if (this.caretOwner != null) {
            this.caretOwner.setSelection(-1, -1);
        }
        this.offsetLabel.setText("Offset: " + offset);
        this.trailLabel.setText("Trail: " + trailing[0]);
        this.caretOwner = text;
        this.caret.setVisible(text != null);
        CaretInfo info = text.getCaretPlacement(offset, trailing[0] != 0);
        this.caret.setSize(1, info.getHeight());
        this.caret.setLocation(info.getX(), info.getY());
        text.setSelection(offset, offset + 1);
        if (text.getText().length() == offset) {
            this.charLabel.setText("Char: ?");
        } else {
            this.charLabel.setText("Char: " + text.getText().charAt(offset));
        }
    }

    public static void main(String[] args) {
        new CaretExample().run();
    }

    @Override
    protected void sizeShell() {
        this.shell.setSize(this.shell.computeSize(400, -1));
    }
}

