/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.examples.tree.Animation;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.examples.tree.TreeRoot;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class TreeLayout
extends AbstractLayout {
    private int pointOfContact;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    private int[] calculateNewRightContour(int[] old, int[] add, int shift) {
        if (old == null) {
            return add;
        }
        int[] result = new int[Math.max(old.length, add.length)];
        System.arraycopy(add, 0, result, 0, add.length);
        int i = add.length;
        while (i < result.length) {
            result[i] = old[i] + shift;
            ++i;
        }
        return result;
    }

    private int calculateOverlap(int[] leftSubtree, int[] rightSubtree) {
        this.pointOfContact = 0;
        if (leftSubtree == null) {
            return 0;
        }
        int min = Math.min(leftSubtree.length, rightSubtree.length);
        int result = Integer.MAX_VALUE;
        int i = 0;
        while (i < min) {
            int current = leftSubtree[i] + rightSubtree[i];
            if (i > 0) {
                current -= 5;
            }
            if (current < result) {
                result = current;
                this.pointOfContact = i + 1;
            }
            ++i;
        }
        return result;
    }

    public void layout(IFigure container) {
        Animation.recordInitialState(container);
        if (Animation.playbackState(container)) {
            return;
        }
        TreeRoot root = ((TreeBranch)container.getParent()).getRoot();
        Transposer transposer = root.getTransposer();
        int gap = root.getMinorSpacing();
        List subtrees = container.getChildren();
        int previousSubtreeDepth = 0;
        int[] rightContour = null;
        Point reference = transposer.t(container.getBounds().getLocation());
        Point currentXY = reference.getCopy();
        int i = 0;
        while (i < subtrees.size()) {
            TreeBranch subtree = (TreeBranch)((Object)subtrees.get(i));
            Dimension subtreeSize = subtree.getPreferredSize();
            subtree.setSize(subtreeSize);
            subtreeSize = transposer.t(subtreeSize);
            int[] leftContour = subtree.getContourLeft();
            int overlap = this.calculateOverlap(rightContour, leftContour);
            if (!subtree.getRoot().isCompressed()) {
                overlap = 0;
            }
            int contactDepth = this.pointOfContact;
            subtree.setLocation(transposer.t(currentXY.getTranslated(-overlap, 0)));
            int advance = gap + subtreeSize.width - overlap;
            rightContour = this.calculateNewRightContour(rightContour, subtree.getContourRight(), advance);
            currentXY.x += advance;
            int shiftRight = reference.x - transposer.t((Rectangle)subtree.getBounds()).x;
            if (shiftRight > 0) {
                currentXY.x += shiftRight;
                Point correction = transposer.t(new Point(shiftRight, 0));
                int j = 0;
                while (j <= i) {
                    ((IFigure)subtrees.get(j)).translate(correction.x, correction.y);
                    ++j;
                }
            }
            if (contactDepth > previousSubtreeDepth) {
                TreeBranch branch = (TreeBranch)((Object)subtrees.get(i - 1));
                int slack = transposer.t((Rectangle)subtree.getBounds()).x - transposer.t(branch.getBounds()).right() - gap + this.calculateOverlap(branch.getContourRight(), subtree.getContourLeft());
                int end = i;
                int begin = end - 1;
                while (begin > 0 && ((TreeBranch)((Object)subtrees.get(begin))).getDepth() < contactDepth) {
                    --begin;
                }
                int j = begin + 1;
                while (j < end) {
                    branch = (TreeBranch)((Object)subtrees.get(j));
                    Point shift = transposer.t(new Point(slack * (j - begin) / (end - begin), 0));
                    branch.translate(shift.x, shift.y);
                    ++j;
                }
            }
            previousSubtreeDepth = subtree.getDepth();
            ++i;
        }
    }
}

