/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.text;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.examples.text.TextFlowFactory;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TextFlowLargeExample {
    static int KEYS_TYPED = 0;
    static boolean PERFORMANCE = false;
    static FigureCanvas canvas;
    static TextFlow target;
    static FlowPage page;
    static Font regularFont;
    static Font boldFont;

    static {
        regularFont = new Font((Device)Display.getDefault(), "Arial", 15, 0);
        boldFont = new Font((Device)Display.getDefault(), "Comic Sans MS", 16, 1);
    }

    public static void main(String[] args) {
        Display d = Display.getDefault();
        Shell shell = new Shell(d);
        shell.setLayout((Layout)new GridLayout());
        canvas = new FigureCanvas((Composite)shell);
        canvas.setLayoutData((Object)new GridData(1808));
        canvas.setVerticalScrollBarVisibility(FigureCanvas.ALWAYS);
        canvas.getViewport().setContentsTracksWidth(true);
        shell.open();
        canvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextFlowLargeExample.addText(e.character);
            }
        });
        page = new FlowPage();
        TextFlowLargeExample.populatePage();
        canvas.setContents((IFigure)page);
        while (!shell.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
    }

    protected static void addText(char c) {
        if ((c <= 'Z' && c >= 'A' || c <= 'z' && c >= 'a' || c == ' ') && target != null) {
            target.setText(String.valueOf(target.getText()) + c);
            if (PERFORMANCE) {
                int cfr_ignored_0 = KEYS_TYPED % 10;
            }
            ++KEYS_TYPED;
        }
    }

    public static void populatePage() {
        target = new TextFlow("Normal text.");
        target.setToolTip((IFigure)new Label("This is a Tooltip"));
        page.add((IFigure)target);
        page.setOpaque(true);
        page.setBackgroundColor(ColorConstants.white);
        int i = 0;
        while (i < 20) {
            BlockFlow bf = new BlockFlow();
            page.add((IFigure)bf);
            if (i == 0) {
                bf.add((IFigure)target);
            }
            InlineFlow ff = new InlineFlow();
            ff.add((IFigure)new TextFlow("This is the first small sentence. "));
            bf.add((IFigure)ff);
            InlineFlow inline = new InlineFlow();
            TextFlowFactory.addSentences((IFigure)inline, 4);
            ff.add((IFigure)inline);
            BlockFlow block = new BlockFlow();
            block.setHorizontalAligment(2);
            TextFlowFactory.addFontSizes((Figure)block, 5, 25);
            page.add((IFigure)block);
            ++i;
        }
    }
}

