/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.model.Block;
import org.eclipse.gef.examples.text.model.InlineContainer;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.ApplyBooleanStyle;
import org.eclipse.gef.examples.text.model.commands.ApplyMultiStyle;
import org.eclipse.gef.examples.text.model.commands.ChangeString;
import org.eclipse.gef.examples.text.model.commands.CompoundEditCommand;
import org.eclipse.gef.examples.text.model.commands.ConvertElementCommand;
import org.eclipse.gef.examples.text.model.commands.MergeWithPrevious;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;
import org.eclipse.gef.examples.text.model.commands.NestElementCommand;
import org.eclipse.gef.examples.text.model.commands.ProcessMacroCommand;
import org.eclipse.gef.examples.text.model.commands.PromoteElementCommand;
import org.eclipse.gef.examples.text.model.commands.RemoveRange;
import org.eclipse.gef.examples.text.model.commands.RemoveText;
import org.eclipse.gef.examples.text.model.commands.SubdivideElement;
import org.eclipse.gef.examples.text.requests.TextRequest;

public class BlockEditPolicy
extends GraphicalEditPolicy {
    private static Command checkForConversion(TextLocation location) {
        TextRun run = (TextRun)location.part.getModel();
        String prefix = run.getText().substring(0, location.offset);
        if (prefix.endsWith("<b>")) {
            InlineContainer converted = new InlineContainer(6);
            converted.getStyle().setBold(true);
            TextRun boldText = new TextRun("BOLD");
            converted.add(boldText);
            ProcessMacroCommand command = new ProcessMacroCommand(run, location.offset - 3, location.offset, converted, new ModelLocation(boldText, 0));
            command.setEndLocation(new ModelLocation(boldText, 1));
            return command;
        }
        if (prefix.equals("()")) {
            Block list = new Block(1);
            TextRun bullet = new TextRun("", 3);
            list.add(bullet);
            ConvertElementCommand command = new ConvertElementCommand(run, 0, 2, list, new ModelLocation(bullet, 0));
            return command;
        }
        if (prefix.equals("import")) {
            Block imports = new Block(3);
            TextRun statement = new TextRun("", 1);
            imports.add(statement);
            ConvertElementCommand command = new ConvertElementCommand(run, 0, 6, imports, new ModelLocation(statement, 0));
            return command;
        }
        return null;
    }

    private static Command getBackspaceCommand(TextRequest request) {
        MiniEdit remove;
        TextLocation where = request.getSelectionRange().begin;
        CompoundEditCommand command = (CompoundEditCommand)request.getPreviousCommand();
        if (command == null) {
            command = new CompoundEditCommand("Backspace");
        }
        TextRun run = (TextRun)where.part.getModel();
        if (where.offset == 0) {
            remove = BlockEditPolicy.getMergeBackspaceEdit(request);
            command.setBeginLocation(new ModelLocation(run, where.offset));
            command.setEndLocation(new ModelLocation(run, where.offset));
        } else {
            remove = new RemoveText(run, where.offset - 1, where.offset);
            command.setBeginLocation(new ModelLocation(run, where.offset - 1));
            command.setEndLocation(new ModelLocation(run, where.offset));
        }
        command.pendEdit(remove);
        return command;
    }

    public Command getCommand(Request request) {
        if (TextRequest.REQ_STYLE == request.getType()) {
            return BlockEditPolicy.getTextStyleApplication((TextRequest)request);
        }
        if (TextRequest.REQ_INSERT == request.getType() || TextRequest.REQ_OVERWRITE == request.getType() || TextRequest.REQ_REMOVE_RANGE == request.getType()) {
            return BlockEditPolicy.getChangeTextCommand((TextRequest)request);
        }
        if (TextRequest.REQ_BACKSPACE == request.getType()) {
            return BlockEditPolicy.getBackspaceCommand((TextRequest)request);
        }
        if (TextRequest.REQ_DELETE == request.getType()) {
            return BlockEditPolicy.getDeleteCommand((TextRequest)request);
        }
        if (TextRequest.REQ_NEWLINE == request.getType()) {
            return BlockEditPolicy.getNewlineCommand((TextRequest)request);
        }
        if (TextRequest.REQ_UNINDENT == request.getType()) {
            return BlockEditPolicy.getUnindentCommand((TextRequest)request);
        }
        if (TextRequest.REQ_INDENT == request.getType()) {
            return BlockEditPolicy.getIndentCommand((TextRequest)request);
        }
        return null;
    }

    private static Command getTextStyleApplication(TextRequest request) {
        SelectionRange range = request.getSelectionRange();
        ModelLocation start = new ModelLocation((TextRun)range.begin.part.getModel(), range.begin.offset);
        ModelLocation end = new ModelLocation((TextRun)range.end.part.getModel(), range.end.offset);
        CompoundEditCommand command = new CompoundEditCommand("Set Style");
        command.setBeginLocation(start);
        command.setEndLocation(end);
        String styleID = request.getStyleKeys()[0];
        if ("alignment".equals(styleID) || "orientation".equals(styleID)) {
            Object value = request.getStyleValues()[0];
            range.getLeafParts().forEach(ep -> {
                TextRun run = (TextRun)ep.getModel();
                command.pendEdit(new ApplyMultiStyle(run.getBlockContainer(), styleID, value));
            });
        } else if (!range.isEmpty()) {
            command.pendEdit(new ApplyBooleanStyle(start, end, request.getStyleKeys(), request.getStyleValues()));
        }
        return command;
    }

    private static Command getIndentCommand(TextRequest request) {
        SelectionRange range = request.getSelectionRange();
        return new NestElementCommand(range.begin.part, range.begin.offset);
    }

    private static Command getUnindentCommand(TextRequest request) {
        SelectionRange range = request.getSelectionRange();
        return new PromoteElementCommand(range.begin.part, range.begin.offset);
    }

    private static Command getDeleteCommand(TextRequest request) {
        TextLocation where = request.getSelectionRange().begin;
        if (where.offset == where.part.getLength()) {
            return null;
        }
        TextRun run = (TextRun)where.part.getModel();
        RemoveText remove = new RemoveText(run, where.offset, where.offset + 1);
        CompoundEditCommand command = (CompoundEditCommand)request.getPreviousCommand();
        if (command == null) {
            command = new CompoundEditCommand("Delete");
            command.setBeginLocation(new ModelLocation(run, where.offset));
            command.setEndLocation(new ModelLocation(run, where.offset + 1));
        }
        command.pendEdit(remove);
        return command;
    }

    private static MiniEdit getMergeBackspaceEdit(TextRequest request) {
        TextEditPart part = request.getSelectionRange().begin.part;
        MergeWithPrevious edit = new MergeWithPrevious(part);
        if (edit.canApply()) {
            return edit;
        }
        return null;
    }

    private static Command getNewlineCommand(TextRequest request) {
        TextLocation where = request.getSelectionRange().end;
        TextRun run = (TextRun)where.part.getModel();
        SubdivideElement edit = new SubdivideElement(run, where.offset);
        CompoundEditCommand command = null;
        command = request.getPreviousCommand() instanceof CompoundEditCommand ? (CompoundEditCommand)request.getPreviousCommand() : new CompoundEditCommand("typing");
        command.pendEdit(edit);
        return command;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof TextRequest) {
            return this.getHost();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Command getChangeTextCommand(TextRequest request) {
        Command result;
        SelectionRange range;
        CompoundEditCommand command = null;
        AppendableCommand appendableCommand = request.getPreviousCommand();
        if (appendableCommand instanceof CompoundEditCommand) {
            void cec;
            CompoundEditCommand compoundEditCommand = (CompoundEditCommand)appendableCommand;
            CompoundEditCommand cfr_ignored_0 = (CompoundEditCommand)appendableCommand;
            command = cec;
        }
        if ((range = request.getSelectionRange()).isEmpty() && request.getText().equals(" ") && (result = BlockEditPolicy.checkForConversion(request.getSelectionRange().begin)) != null) {
            return result;
        }
        TextRun rangeBegin = (TextRun)range.begin.part.getModel();
        if (command == null) {
            TextRun rangeEnd = (TextRun)range.end.part.getModel();
            command = new CompoundEditCommand("typing");
            command.setBeginLocation(new ModelLocation(rangeBegin, range.begin.offset));
            if (!range.isEmpty()) {
                command.setEndLocation(new ModelLocation(rangeEnd, range.end.offset));
                RemoveRange remove = new RemoveRange(rangeBegin, range.begin.offset, rangeEnd, range.end.offset);
                command.pendEdit(remove);
            }
        } else {
            Assert.isTrue((boolean)range.isEmpty());
        }
        if (request.getText() != null) {
            ChangeString insert = new ChangeString(rangeBegin, request.getText(), range.begin.offset, request.getType() == TextRequest.REQ_OVERWRITE);
            command.pendEdit(insert);
        }
        return command;
    }
}

