/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.Transition;
import org.eclipse.gef.examples.flow.parts.BottomAnchor;
import org.eclipse.gef.examples.flow.parts.TopAnchor;
import org.eclipse.gef.examples.flow.parts.TransitionPart;
import org.eclipse.gef.examples.flow.policies.ActivityDirectEditPolicy;
import org.eclipse.gef.examples.flow.policies.ActivityEditPolicy;
import org.eclipse.gef.examples.flow.policies.ActivityNodeEditPolicy;
import org.eclipse.gef.examples.flow.policies.ActivitySourceEditPolicy;
import org.eclipse.gef.tools.DirectEditManager;

public abstract class ActivityPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    protected DirectEditManager manager;

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener(this);
    }

    protected void applyGraphResults(CompoundDirectedGraph graph, Map map) {
        Node n = (Node)map.get(this);
        this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, n.height));
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            TransitionPart trans = (TransitionPart)((Object)this.getSourceConnections().get(i));
            trans.applyGraphResults(graph, map);
            ++i;
        }
    }

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            TransitionPart part = (TransitionPart)((Object)this.getSourceConnections().get(i));
            part.contributeToGraph(graph, map);
            ++i;
        }
        this.getChildren().forEach(child -> child.contributeEdgesToGraph(graph, map));
    }

    public abstract void contributeNodesToGraph(CompoundDirectedGraph var1, Subgraph var2, Map var3);

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityNodeEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ActivitySourceEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ActivityEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ActivityDirectEditPolicy());
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().removePropertyChangeListener(this);
    }

    public Activity getModel() {
        return (Activity)super.getModel();
    }

    public List<? extends ActivityPart> getChildren() {
        return super.getChildren();
    }

    protected List<Transition> getModelSourceConnections() {
        return this.getModel().getOutgoingTransitions();
    }

    protected List<Transition> getModelTargetConnections() {
        return this.getModel().getIncomingTransitions();
    }

    abstract int getAnchorOffset();

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new BottomAnchor(this.getFigure(), this.getAnchorOffset());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new BottomAnchor(this.getFigure(), this.getAnchorOffset());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new TopAnchor(this.getFigure(), this.getAnchorOffset());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new TopAnchor(this.getFigure(), this.getAnchorOffset());
    }

    protected void performDirectEdit() {
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Children".equals(prop)) {
            this.refreshChildren();
        } else if ("inputs".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("outputs".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("name".equals(prop)) {
            this.refreshVisuals();
        }
        ((GraphicalEditPart)this.getViewer().getContents()).getFigure().revalidate();
    }

    protected void setFigure(IFigure figure) {
        figure.getBounds().setSize(0, 0);
        super.setFigure(figure);
    }

    public String toString() {
        return this.getModel().toString();
    }
}

