/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.EventListenerList;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;

public abstract class AbstractEditPart
implements EditPart,
RequestConstants,
IAdaptable {
    protected static final int FLAG_ACTIVE = 1;
    protected static final int FLAG_FOCUS = 2;
    protected static final int MAX_FLAG = 2;
    private Object model;
    private int flags;
    private EditPart parent;
    private int selected;
    private Object[] policies;
    protected List<EditPart> children;
    EventListenerList eventListeners = new EventListenerList();

    @Override
    public void activate() {
        this.setFlag(1, true);
        this.activateEditPolicies();
        this.getChildren().forEach(c -> c.activate());
        this.fireActivated();
    }

    protected void activateEditPolicies() {
        this.getEditPolicyIterable().forEach(EditPolicy::activate);
    }

    protected void addChild(EditPart child, int index) {
        Assert.isNotNull((Object)child);
        if (index == -1) {
            index = this.getChildren().size();
        }
        if (this.children == null) {
            this.children = new ArrayList<EditPart>(2);
        }
        this.children.add(index, child);
        child.setParent(this);
        this.addChildVisual(child, index);
        child.addNotify();
        if (this.isActive()) {
            child.activate();
        }
        this.fireChildAdded(child, index);
    }

    protected abstract void addChildVisual(EditPart var1, int var2);

    @Override
    public void addEditPartListener(EditPartListener listener) {
        this.eventListeners.addListener(EditPartListener.class, (Object)listener);
    }

    @Override
    public void addNotify() {
        this.register();
        this.createEditPolicies();
        this.getChildren().forEach(c -> c.addNotify());
        this.refresh();
    }

    protected EditPart createChild(Object model) {
        return this.getViewer().getEditPartFactory().createEditPart(this, model);
    }

    protected abstract void createEditPolicies();

    @Override
    public void deactivate() {
        this.getChildren().forEach(c -> c.deactivate());
        this.deactivateEditPolicies();
        this.setFlag(1, false);
        this.fireDeactivated();
    }

    protected void deactivateEditPolicies() {
        this.getEditPolicyIterable().forEach(EditPolicy::deactivate);
    }

    protected final void debug(String message) {
    }

    protected final void debugFeedback(String message) {
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        if (this.isActive()) {
            this.getEditPolicyIterable().forEach(ep -> ep.eraseSourceFeedback(request));
        }
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        if (this.isActive()) {
            this.getEditPolicyIterable().forEach(ep -> ep.eraseTargetFeedback(request));
        }
    }

    protected void fireActivated() {
        this.getEventListenersIterable(EditPartListener.class).forEach(lst -> lst.partActivated(this));
    }

    protected void fireChildAdded(EditPart child, int index) {
        this.getEventListenersIterable(EditPartListener.class).forEach(lst -> lst.childAdded(child, index));
    }

    protected void fireDeactivated() {
        this.getEventListenersIterable(EditPartListener.class).forEach(lst -> lst.partDeactivated(this));
    }

    protected void fireRemovingChild(EditPart child, int index) {
        this.getEventListenersIterable(EditPartListener.class).forEach(lst -> lst.removingChild(child, index));
    }

    protected void fireSelectionChanged() {
        this.getEventListenersIterable(EditPartListener.class).forEach(lst -> lst.selectedStateChanged(this));
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        return null;
    }

    public <T> T getAdapter(Class<T> key) {
        if (AccessibleEditPart.class == key) {
            return key.cast((Object)this.getAccessibleEditPart());
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, key);
    }

    @Override
    public List<? extends EditPart> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    @Override
    public Command getCommand(Request request) {
        Command command = null;
        for (EditPolicy ep : this.getEditPolicyIterable()) {
            Command command2 = command = command != null ? command.chain(ep.getCommand(request)) : ep.getCommand(request);
        }
        return command;
    }

    protected final <T> Iterator<T> getEventListeners(Class<T> clazz) {
        return this.eventListeners.getListeners(clazz);
    }

    protected <T> Iterable<T> getEventListenersIterable(Class<T> listenerType) {
        return this.eventListeners.getListenersIterable(listenerType);
    }

    @Override
    public EditPolicy getEditPolicy(Object key) {
        if (this.policies != null) {
            int i = 0;
            while (i < this.policies.length) {
                if (key.equals(this.policies[i])) {
                    return (EditPolicy)this.policies[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    @Deprecated(since="3.15", forRemoval=true)
    protected final EditPolicyIterator getEditPolicyIterator() {
        return new EditPolicyIterator(this.policies);
    }

    protected final Iterable<EditPolicy> getEditPolicyIterable() {
        return () -> new EditPolicyIterator2(this.policies);
    }

    protected final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public EditPart getParent() {
        return this.parent;
    }

    @Override
    public RootEditPart getRoot() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getRoot();
    }

    @Override
    public int getSelected() {
        return this.selected;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        for (EditPolicy ep : this.getEditPolicyIterable()) {
            EditPart editPart = ep.getTargetEditPart(request);
            if (editPart == null) continue;
            return editPart;
        }
        if ("selection" == request.getType() && this.isSelectable()) {
            return this;
        }
        return null;
    }

    @Override
    public EditPartViewer getViewer() {
        RootEditPart root = this.getRoot();
        if (root == null) {
            return null;
        }
        return root.getViewer();
    }

    @Override
    public boolean hasFocus() {
        return this.getFlag(2);
    }

    @Override
    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        Assert.isNotNull((Object)key, (String)"Edit Policies must be installed with keys");
        if (this.policies == null) {
            this.policies = new Object[2];
            this.policies[0] = key;
            this.policies[1] = editPolicy;
        } else {
            int index = 0;
            while (index < this.policies.length && !key.equals(this.policies[index])) {
                index += 2;
            }
            if (index < this.policies.length) {
                EditPolicy old;
                if ((old = (EditPolicy)this.policies[++index]) != null && this.isActive()) {
                    old.deactivate();
                }
                this.policies[index] = editPolicy;
            } else {
                Object[] newPolicies = new Object[this.policies.length + 2];
                System.arraycopy(this.policies, 0, newPolicies, 0, this.policies.length);
                this.policies = newPolicies;
                this.policies[index] = key;
                this.policies[index + 1] = editPolicy;
            }
        }
        if (editPolicy != null) {
            editPolicy.setHost(this);
            if (this.isActive()) {
                editPolicy.activate();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.getFlag(1);
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void performRequest(Request req) {
    }

    @Override
    public void refresh() {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void refreshChildren() {
        Map<Object, EditPart> modelToEditPart = Collections.emptyMap();
        if (!this.getChildren().isEmpty()) {
            modelToEditPart = new HashMap(this.getChildren().size());
            for (EditPart editPart : this.getChildren()) {
                modelToEditPart.put(editPart.getModel(), editPart);
            }
        }
        List list = this.getModelChildren();
        List<? extends EditPart> curChildren = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            Object curModel = list.get(i);
            if (i >= curChildren.size() || curChildren.get(i).getModel() != curModel) {
                EditPart editPart = (EditPart)modelToEditPart.get(curModel);
                if (editPart != null) {
                    this.reorderChild(editPart, i);
                } else {
                    editPart = this.createChild(curModel);
                    this.addChild(editPart, i);
                }
            }
            ++i;
        }
        int size = curChildren.size();
        if (i < size) {
            ArrayList<EditPart> trash = new ArrayList<EditPart>(size - i);
            while (i < size) {
                trash.add(curChildren.get(i));
                ++i;
            }
            trash.forEach(this::removeChild);
        }
    }

    protected void refreshVisuals() {
    }

    protected void register() {
        this.registerModel();
        this.registerVisuals();
        this.registerAccessibility();
    }

    protected final void registerAccessibility() {
        if (this.getAccessibleEditPart() != null) {
            this.getViewer().registerAccessibleEditPart(this.getAccessibleEditPart());
        }
    }

    protected void registerModel() {
        this.getViewer().getEditPartRegistry().put(this.getModel(), this);
    }

    protected void registerVisuals() {
    }

    protected void removeChild(EditPart child) {
        Assert.isNotNull((Object)child);
        int index = this.getChildren().indexOf(child);
        if (index < 0) {
            return;
        }
        this.fireRemovingChild(child, index);
        if (this.isActive()) {
            child.deactivate();
        }
        child.removeNotify();
        this.removeChildVisual(child);
        child.setParent(null);
        this.getChildren().remove(child);
    }

    protected abstract void removeChildVisual(EditPart var1);

    @Override
    public void removeEditPartListener(EditPartListener listener) {
        this.eventListeners.removeListener(EditPartListener.class, (Object)listener);
    }

    @Override
    public void removeEditPolicy(Object key) {
        if (this.policies == null) {
            return;
        }
        int i = 0;
        while (i < this.policies.length) {
            if (key.equals(this.policies[i])) {
                EditPolicy policy = (EditPolicy)this.policies[++i];
                this.policies[i] = null;
                if (this.isActive() && policy != null) {
                    policy.deactivate();
                }
            }
            i += 2;
        }
    }

    @Override
    public void removeNotify() {
        if (this.getSelected() != 0) {
            this.getViewer().deselect(this);
        }
        if (this.hasFocus()) {
            this.getViewer().setFocus(null);
        }
        this.getChildren().forEach(c -> c.removeNotify());
        this.unregister();
    }

    protected void reorderChild(EditPart editpart, int index) {
        this.removeChildVisual(editpart);
        this.children.remove(editpart);
        this.children.add(index, editpart);
        this.addChildVisual(editpart, index);
    }

    protected final void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    @Override
    public void setFocus(boolean value) {
        Assert.isLegal((this.isSelectable() || !value ? 1 : 0) != 0, (String)"An EditPart has to be selectable (isSelectable() == true) in order to obtain focus.");
        if (this.hasFocus() == value) {
            return;
        }
        this.setFlag(2, value);
        this.fireSelectionChanged();
    }

    @Override
    public void setModel(Object model) {
        this.model = model;
    }

    @Override
    public void setParent(EditPart parent) {
        this.parent = parent;
    }

    @Override
    public void setSelected(int value) {
        Assert.isLegal((this.isSelectable() || value == 0 ? 1 : 0) != 0, (String)"An EditPart has to be selectable (isSelectable() == true) in order to get selected.");
        if (this.selected == value) {
            return;
        }
        this.selected = value;
        this.fireSelectionChanged();
    }

    @Override
    public void showSourceFeedback(Request request) {
        if (!this.isActive()) {
            return;
        }
        this.getEditPolicyIterable().forEach(ep -> ep.showSourceFeedback(request));
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (!this.isActive()) {
            return;
        }
        this.getEditPolicyIterable().forEach(ep -> ep.showTargetFeedback(request));
    }

    public String toString() {
        String c = this.getClass().getName();
        c = c.substring(c.lastIndexOf(46) + 1);
        return c + "( " + String.valueOf(this.getModel()) + " )";
    }

    @Override
    public boolean understandsRequest(Request req) {
        for (EditPolicy ep : this.getEditPolicyIterable()) {
            if (!ep.understandsRequest(req)) continue;
            return true;
        }
        return false;
    }

    protected void unregister() {
        this.unregisterAccessibility();
        this.unregisterVisuals();
        this.unregisterModel();
    }

    protected final void unregisterAccessibility() {
        if (this.getAccessibleEditPart() != null) {
            this.getViewer().unregisterAccessibleEditPart(this.getAccessibleEditPart());
        }
    }

    protected void unregisterModel() {
        Map registry = this.getViewer().getEditPartRegistry();
        if (registry.get(this.getModel()) == this) {
            registry.remove(this.getModel());
        }
    }

    protected void unregisterVisuals() {
    }

    protected static class EditPolicyIterator {
        private Object[] list;
        private int offset = 0;
        private final int length;

        EditPolicyIterator(Object[] list) {
            this.list = list;
            this.length = list == null ? 0 : list.length;
        }

        public EditPolicyIterator(List list) {
            this(list.toArray());
        }

        public EditPolicy next() {
            if (this.offset < this.length) {
                return (EditPolicy)this.list[this.offset++];
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.list != null) ** GOTO lbl4
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.offset;
lbl4:
                // 2 sources

                ** while (this.offset < this.list.length && !(this.list[this.offset] instanceof EditPolicy))
            }
lbl5:
            // 1 sources

            return this.offset < this.list.length;
        }
    }

    private static class EditPolicyIterator2
    extends EditPolicyIterator
    implements Iterator<EditPolicy> {
        EditPolicyIterator2(Object[] list) {
            super(list);
        }
    }
}

