/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.tree;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.examples.tree.AbstractBranchLayout;
import org.eclipse.draw2d.examples.tree.Animation;
import org.eclipse.draw2d.examples.tree.TreeBranch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

class HangingLayout
extends AbstractBranchLayout {
    HangingLayout(TreeBranch branch) {
        super(branch);
    }

    @Override
    void calculateDepth() {
        this.depth = this.getSubtrees().stream().mapToInt(TreeBranch::getDepth).sum() + 1;
    }

    @Override
    void setRowHeights(int[] heights, int offset) {
        super.setRowHeights(heights, offset);
        ++offset;
        if (this.branch.isExpanded()) {
            for (TreeBranch subtree : this.branch.getSubtrees()) {
                subtree.setRowHeights(heights, offset);
                offset += subtree.getDepth();
            }
        }
    }

    @Override
    void updateRowHeights() {
        Transposer transposer = this.branch.getRoot().getTransposer();
        this.preferredRowHeights = new int[this.getDepth()];
        this.preferredRowHeights[0] = transposer.t((Dimension)this.branch.getNode().getPreferredSize()).height + this.getMajorSpacing();
        if (!this.branch.isExpanded()) {
            return;
        }
        int offset = 1;
        for (TreeBranch subtree : this.branch.getSubtrees()) {
            int[] rowHeights = subtree.getPreferredRowHeights();
            int row = 0;
            while (row < rowHeights.length) {
                this.preferredRowHeights[row + offset] = rowHeights[row];
                ++row;
            }
            offset += subtree.getDepth();
        }
    }

    int getGap() {
        return this.branch.getRoot().getMinorSpacing();
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Transposer transposer = this.branch.getRoot().getTransposer();
        Dimension result = transposer.t(this.branch.getNode().getPreferredSize().getCopy());
        result.height = this.rowHeight;
        IFigure pane = this.branch.getContentsPane();
        if (!pane.isVisible() || pane.getChildren().isEmpty()) {
            return transposer.t(result);
        }
        Dimension d = transposer.t(this.branch.getContentsPane().getPreferredSize());
        result.width = Math.max(result.width, d.width + this.getGap() * 2);
        result.height += d.height;
        return transposer.t(result);
    }

    public void layout(IFigure f) {
        Animation.recordInitialState(f);
        if (Animation.playbackState(f)) {
            return;
        }
        this.branch.getContentsPane().validate();
        Transposer transposer = this.getTransposer();
        Rectangle clientArea = new Rectangle();
        this.branch.getClientArea(clientArea);
        clientArea = transposer.t(clientArea);
        Rectangle nodeBounds = new Rectangle();
        nodeBounds.setSize(transposer.t(this.branch.getNode().getPreferredSize()));
        nodeBounds.height = this.rowHeight - this.getMajorSpacing();
        nodeBounds.setLocation(clientArea.x, clientArea.y);
        this.branch.getNode().setBounds(transposer.t(nodeBounds));
        IFigure contents = this.branch.getContentsPane();
        Rectangle contentsBounds = new Rectangle(clientArea.getLocation().translate(this.getGap() * 2, this.rowHeight), transposer.t(contents.getPreferredSize()));
        contents.setBounds(transposer.t(contentsBounds));
    }

    @Override
    void paintLines(Graphics g) {
        List<TreeBranch> children = this.branch.getSubtrees();
        if (children.isEmpty()) {
            return;
        }
        int gap = this.getGap();
        IFigure node = this.branch.getNode();
        if (this.getTransposer().isEnabled()) {
            int x = node.getBounds().right();
            int y = node.getBounds().y() + gap;
            int right = x;
            for (TreeBranch subTree : children) {
                Point pt = subTree.getNodeBounds().getTop();
                g.drawLine(pt.x(), y, pt.x(), pt.y());
                right = Math.max(right, pt.x());
            }
            g.drawLine(x, y, right, y);
        } else {
            int y;
            int x = node.getBounds().x() + gap;
            int bottom = y = node.getBounds().bottom();
            for (TreeBranch subTree : children) {
                Point pt = subTree.getNodeBounds().getLeft();
                g.drawLine(x, pt.y(), pt.x(), pt.y());
                bottom = Math.max(bottom, pt.y());
            }
            g.drawLine(x, y, x, bottom);
        }
    }

    @Override
    void updateContours() {
        Transposer transposer = this.getTransposer();
        this.branch.validate();
        this.cachedContourLeft = new int[this.getDepth()];
        this.cachedContourRight = new int[this.getDepth()];
        Rectangle clientArea = transposer.t(this.branch.getClientArea(Rectangle.SINGLETON));
        Rectangle nodeBounds = transposer.t(this.branch.getNodeBounds());
        int rightEdge = clientArea.right();
        this.cachedContourLeft[0] = nodeBounds.x() - clientArea.x();
        this.cachedContourRight[0] = rightEdge - nodeBounds.right();
        if (!this.branch.isExpanded()) {
            return;
        }
        int leftSide = this.getGap();
        int i = 1;
        while (i < this.getDepth()) {
            this.cachedContourLeft[i] = leftSide;
            ++i;
        }
        int offset = 1;
        for (TreeBranch subtree : this.branch.getSubtrees()) {
            int rightMargin = rightEdge - transposer.t(subtree.getBounds()).right();
            int[] rightContour = subtree.getContourRight();
            int j = 0;
            while (j < rightContour.length) {
                this.cachedContourRight[j + offset] = rightContour[j] + rightMargin;
                ++j;
            }
            offset += subtree.getDepth();
        }
    }
}

