/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.StructuredActivity;
import org.eclipse.gef.examples.flow.model.Transition;

public class SplitTransitionCommand
extends Command {
    private StructuredActivity parent;
    private Activity oldSource;
    private Activity oldTarget;
    private Transition transition;
    private Activity newActivity;
    private Transition newIncomingTransition;
    private Transition newOutgoingTransition;

    public void execute() {
        this.oldSource.removeOutput(this.transition);
        this.oldTarget.removeInput(this.transition);
        this.parent.addChild(this.newActivity);
        this.newIncomingTransition = new Transition(this.oldSource, this.newActivity);
        this.newOutgoingTransition = new Transition(this.newActivity, this.oldTarget);
    }

    public void redo() {
        this.oldSource.addOutput(this.newIncomingTransition);
        this.oldTarget.addInput(this.newOutgoingTransition);
        this.newActivity.addInput(this.newIncomingTransition);
        this.newActivity.addOutput(this.newOutgoingTransition);
        this.parent.addChild(this.newActivity);
        this.oldSource.removeOutput(this.transition);
        this.oldTarget.removeInput(this.transition);
    }

    public void setParent(StructuredActivity activity) {
        this.parent = activity;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
        this.oldSource = transition.source;
        this.oldTarget = transition.target;
    }

    public void setNewActivity(Activity activity) {
        this.newActivity = activity;
        this.newActivity.setName("a " + (this.parent.getChildren().size() + 1));
    }

    public void undo() {
        this.oldSource.removeOutput(this.newIncomingTransition);
        this.oldTarget.removeInput(this.newOutgoingTransition);
        this.newActivity.removeInput(this.newIncomingTransition);
        this.newActivity.removeOutput(this.newOutgoingTransition);
        this.parent.removeChild(this.newActivity);
        this.oldSource.addOutput(this.transition);
        this.oldTarget.addInput(this.transition);
    }
}

