/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextCommand;

public class CompoundTextCommand
extends Command
implements TextCommand,
AppendableCommand {
    private List pending = new ArrayList();
    private List applied = new ArrayList();

    public CompoundTextCommand() {
    }

    public CompoundTextCommand(String label) {
        super(label);
    }

    public void add(TextCommand command) {
        if (command != null) {
            this.pending.add(command);
        }
    }

    public boolean canExecute() {
        return this.canExecutePending();
    }

    @Override
    public boolean canExecutePending() {
        if (this.pending.isEmpty()) {
            return false;
        }
        for (Object element : this.pending) {
            Command cmd = (Command)element;
            if (cmd == null) {
                return false;
            }
            if (cmd.canExecute()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (Object element : this.applied) {
            ((Command)element).dispose();
        }
        this.flushPending();
    }

    public void execute() {
        this.executePending();
    }

    @Override
    public void executePending() {
        int i = 0;
        while (i < this.pending.size()) {
            Command cmd = (Command)this.pending.get(i);
            cmd.execute();
            this.applied.add(cmd);
            ++i;
        }
        this.flushPending();
    }

    @Override
    public void flushPending() {
        this.pending.clear();
    }

    @Override
    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        if (this.applied.isEmpty()) {
            return null;
        }
        return ((TextCommand)this.applied.get(this.applied.size() - 1)).getExecuteSelectionRange(viewer);
    }

    @Override
    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        if (this.applied.isEmpty()) {
            return null;
        }
        return ((TextCommand)this.applied.get(this.applied.size() - 1)).getExecuteSelectionRange(viewer);
    }

    @Override
    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        if (this.applied.isEmpty()) {
            return null;
        }
        return ((TextCommand)this.applied.get(0)).getUndoSelectionRange(viewer);
    }

    public void redo() {
        for (Object element : this.applied) {
            ((Command)element).redo();
        }
    }

    public void undo() {
        int i = this.applied.size() - 1;
        while (i >= 0) {
            ((Command)this.applied.get(i)).undo();
            --i;
        }
    }
}

