/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.examples.shapes.ShapesExampleMessages;
import org.eclipse.gef.examples.shapes.model.ShapesDiagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class ShapesCreationWizard
extends Wizard
implements INewWizard {
    private static int fileCount = 1;
    private CreationPage page1;

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page1 = new CreationPage(workbench, selection);
    }

    public boolean performFinish() {
        return this.page1.finish();
    }

    private class CreationPage
    extends WizardNewFileCreationPage {
        private static final String DEFAULT_EXTENSION = ".shapes";
        private final IWorkbench workbench;

        CreationPage(IWorkbench workbench, IStructuredSelection selection) {
            super("shapeCreationPage1", selection);
            this.workbench = workbench;
            this.setTitle(MessageFormat.format(ShapesExampleMessages.ShapesCreationWizard_CreateANewFile, DEFAULT_EXTENSION));
            this.setDescription(MessageFormat.format(ShapesExampleMessages.ShapesCreationWizard_CreateANewFile, DEFAULT_EXTENSION));
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setFileName("shapesExample" + fileCount + DEFAULT_EXTENSION);
            this.setPageComplete(this.validatePage());
        }

        private Object createDefaultContent() {
            return new ShapesDiagram();
        }

        boolean finish() {
            IFile newFile = this.createNewFile();
            ++fileCount;
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            if (newFile != null && page != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected InputStream getInitialContents() {
            ByteArrayInputStream bais = null;
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                            oos.writeObject(this.createDefaultContent());
                            oos.flush();
                            bais = new ByteArrayInputStream(baos.toByteArray());
                        }
                        if (baos == null) return bais;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (baos == null) throw throwable;
                        baos.close();
                        throw throwable;
                    }
                    baos.close();
                    return bais;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return bais;
        }

        private boolean validateFilename() {
            if (this.getFileName() != null && this.getFileName().endsWith(DEFAULT_EXTENSION)) {
                return true;
            }
            this.setErrorMessage(MessageFormat.format(ShapesExampleMessages.ShapesCreationWizard_FileNameMustEndWith, DEFAULT_EXTENSION));
            return false;
        }

        protected boolean validatePage() {
            return super.validatePage() && this.validateFilename();
        }
    }
}

