/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.ShapesExampleMessages;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.Shape;

public class ConnectionCreateCommand
extends Command {
    private Connection connection;
    private final int lineStyle;
    private final Shape source;
    private Shape target;

    public ConnectionCreateCommand(Shape source, int lineStyle) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(ShapesExampleMessages.ConnectionCreateCommand_ConnectionCreation);
        this.source = source;
        this.lineStyle = lineStyle;
    }

    public boolean canExecute() {
        if (this.source.equals(this.target)) {
            return false;
        }
        return this.source.getSourceConnections().stream().noneMatch(conn -> conn.getTarget().equals(this.target));
    }

    public void execute() {
        this.connection = new Connection(this.source, this.target);
        this.connection.setLineStyle(this.lineStyle);
    }

    public void redo() {
        this.connection.reconnect();
    }

    public void setTarget(Shape target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    public void undo() {
        this.connection.disconnect();
    }
}

