/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.IScrollableFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PuristicScrollPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.CircuitBorder;
import org.eclipse.gef.examples.logicdesigner.figures.FixedConnectionAnchor;
import org.eclipse.gef.examples.logicdesigner.figures.NodeFigure;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.handles.HandleBounds;

public class CircuitFigure
extends NodeFigure
implements HandleBounds,
IScrollableFigure {
    private final ScrollPane scrollpane;

    public CircuitFigure() {
        this.setBorder((Border)new CircuitBorder());
        this.scrollpane = new PuristicScrollPane();
        FreeformLayer pane = new FreeformLayer();
        pane.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.scrollpane);
        this.scrollpane.setViewport((Viewport)new FreeformViewport());
        this.scrollpane.setContents((IFigure)pane);
        this.createConnectionAnchors();
        this.setBackgroundColor(ColorConstants.listBackground);
        this.setOpaque(true);
    }

    protected void createConnectionAnchors() {
        int i = 0;
        while (i < 8) {
            FixedConnectionAnchor in = new FixedConnectionAnchor((IFigure)this);
            FixedConnectionAnchor out = new FixedConnectionAnchor((IFigure)this);
            if (i > 3) {
                in.topDown = false;
                in.offsetV = 5;
                out.topDown = false;
            } else {
                out.offsetV = 5;
            }
            this.setOutputConnectionAnchor(i, (ConnectionAnchor)out);
            this.setInputConnectionAnchor(i, (ConnectionAnchor)in);
            this.outputConnectionAnchors.add(out);
            this.inputConnectionAnchors.add(in);
            ++i;
        }
    }

    public IFigure getContentsPane() {
        return this.scrollpane.getContents();
    }

    protected FixedConnectionAnchor getInputConnectionAnchor(int i) {
        return (FixedConnectionAnchor)((Object)this.connectionAnchors.get(Circuit.TERMINALS_IN[i]));
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getShrinked(new Insets(4, 0, 4, 0));
    }

    protected FixedConnectionAnchor getOutputConnectionAnchor(int i) {
        return (FixedConnectionAnchor)((Object)this.connectionAnchors.get(Circuit.TERMINALS_OUT[i]));
    }

    public Dimension getPreferredSize(int w, int h) {
        Dimension prefSize = super.getPreferredSize(w, h);
        Dimension defaultSize = new Dimension(200, 200);
        prefSize.union(defaultSize);
        return prefSize;
    }

    protected void layoutConnectionAnchors() {
        int i = 0;
        while (i < 4) {
            int x = (2 * i + 1) * this.getSize().width / 8;
            this.getOutputConnectionAnchor(i + 4).setOffsetH(x - 1);
            this.getInputConnectionAnchor(i).setOffsetH(x - 1);
            this.getInputConnectionAnchor(i + 4).setOffsetH(x);
            this.getOutputConnectionAnchor(i).setOffsetH(x);
            ++i;
        }
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle rect = this.getBounds().getCopy();
        rect.shrink(new Insets(4, 0, 4, 0));
        graphics.fillRectangle(rect);
    }

    public void setInputConnectionAnchor(int i, ConnectionAnchor c) {
        this.connectionAnchors.put(Circuit.TERMINALS_IN[i], c);
    }

    public void setOutputConnectionAnchor(int i, ConnectionAnchor c) {
        this.connectionAnchors.put(Circuit.TERMINALS_OUT[i], c);
    }

    public String toString() {
        return "CircuitBoardFigure";
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.layoutConnectionAnchors();
        super.validate();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public ScrollPane getScrollPane() {
        return this.scrollpane;
    }
}

