/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.TextCommand;
import org.eclipse.gef.examples.text.actions.BooleanStyleAction;
import org.eclipse.gef.examples.text.actions.MultiStyleAction;
import org.eclipse.gef.examples.text.actions.StyleService;
import org.eclipse.gef.examples.text.edit.BlockTextPart;
import org.eclipse.gef.examples.text.edit.ContainerTreePart;
import org.eclipse.gef.examples.text.edit.DocumentPart;
import org.eclipse.gef.examples.text.edit.ImportPart;
import org.eclipse.gef.examples.text.edit.ImportsPart;
import org.eclipse.gef.examples.text.edit.InlineTextPart;
import org.eclipse.gef.examples.text.edit.TextFlowPart;
import org.eclipse.gef.examples.text.edit.TextRunTreePart;
import org.eclipse.gef.examples.text.model.Block;
import org.eclipse.gef.examples.text.model.CanvasStyle;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.tools.TextTool;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class TextEditor
extends GraphicalEditor {
    private Container doc;
    private final StyleService styleService = new StyleService();

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.doc.getStyle().setParentStyle(new CanvasStyle(this.getGraphicalViewer().getControl()));
        this.getEditDomain().setDefaultTool((Tool)new TextTool(this.styleService));
        this.getEditDomain().loadDefaultTool();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        ((FigureCanvas)this.getGraphicalViewer().getControl()).getViewport().setContentsTracksWidth(true);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    protected void createActions() {
        super.createActions();
        IKeyBindingService service = this.getSite().getKeyBindingService();
        ActionRegistry registry = this.getActionRegistry();
        BooleanStyleAction action = new BooleanStyleAction(this.styleService, "org.eclipse.gef.text.bold", "bold");
        registry.registerAction((IAction)action);
        service.registerAction((IAction)action);
        action = new BooleanStyleAction(this.styleService, "org.eclipse.gef.text.italic", "italics");
        registry.registerAction((IAction)action);
        service.registerAction((IAction)action);
        action = new BooleanStyleAction(this.styleService, "org.eclipse.gef.text.underline", "underline");
        registry.registerAction((IAction)action);
        service.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.alignLeft", "alignment", 64);
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.alignCenter", "alignment", 2);
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.alignRight", "alignment", 128);
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.ltr", "orientation", 0x2000000);
        registry.registerAction((IAction)action);
        action = new MultiStyleAction(this.styleService, "org.eclipse.gef.text.rtl", "orientation", 0x4000000);
        registry.registerAction((IAction)action);
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalTextViewer viewer = new GraphicalTextViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public <T> T getAdapter(Class<T> type) {
        if (type == IContentOutlinePage.class) {
            return type.cast(this.createOutlinePage());
        }
        if (type == StyleService.class) {
            return type.cast(this.styleService);
        }
        return (T)super.getAdapter(type);
    }

    private IContentOutlinePage createOutlinePage() {
        return new TextOutlinePage(null);
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new TextEditorEditPartFactory());
        this.getGraphicalViewer().setContents((Object)this.doc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSave(IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    try (ObjectOutputStream objStream = new ObjectOutputStream(outputStream);){
                        objStream.writeObject(this.doc);
                        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                        file.setContents((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), true, false, monitor);
                        this.getCommandStack().markSaveLocation();
                    }
                    if (outputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getCommandStack().addCommandStackEventListener(event -> {
            TextCommand command = (TextCommand)event.getCommand();
            if (command != null) {
                GraphicalTextViewer textViewer = (GraphicalTextViewer)this.getGraphicalViewer();
                if (event.getDetail() == 8) {
                    textViewer.setSelectionRange(command.getExecuteSelectionRange(textViewer));
                } else if (event.getDetail() == 16) {
                    textViewer.setSelectionRange(command.getRedoSelectionRange(textViewer));
                } else if (event.getDetail() == 32) {
                    textViewer.setSelectionRange(command.getUndoSelectionRange(textViewer));
                }
            }
        });
        super.init(site, input);
        site.getKeyBindingService().setScopes(new String[]{"org.eclipse.gef.textContext"});
        site.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        site.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setInput(IEditorInput input) {
        IFile file;
        block17: {
            super.setInput(input);
            file = ((IFileEditorInput)input).getFile();
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    InputStream is = file.getContents(false);
                    try {
                        try (ObjectInputStream ois = new ObjectInputStream(is);){
                            this.doc = (Container)ois.readObject();
                        }
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (EOFException eOFException) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.doc == null) {
            this.doc = new Block(5);
            Block preface = new Block(4);
            preface.add(new TextRun("package org.eclipse.gef.examples.text"));
            this.doc.add(preface);
            Block imports = new Block(3);
            this.doc.add(imports);
            imports.add(new TextRun("org.eclipse.draw2d", 1));
            imports.add(new TextRun("org.eclipse.gef", 1));
            Block block = new Block(2);
            block.add(new TextRun("Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html (\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329\u7325\u7334\u7329)\r\nContributors:\n    IBM Corporation - initial API and implementation\n\u0630\u0628\u063a \u0634\u0635\u062c\u062d (Saeed Anwar) - \u0634\u0635\u062c\u062d \u0638\u0635\u0634\u0637\u0635\u0639\u0633 \u0635\u0639\u0633\u0640 \u0630\u0628\u063a (Bug 113700)"));
            this.doc.add(block);
            Block code = new Block(4);
            code.getStyle().setFontFamily("Courier New");
            this.doc.add(code);
            code.add(new TextRun("public void countToANumber(int limit) {\n    for (int i = 0; i < limit; i++)\n        System.out.println(\"Counting: \" + i); //$NON-NLS-1$\n\n}", 5));
        }
        this.setPartName(file.getName());
    }

    private static final class TextEditorEditPartFactory
    implements EditPartFactory {
        private TextEditorEditPartFactory() {
        }

        public EditPart createEditPart(EditPart context, Object model) {
            if (model instanceof Container) {
                Container cont = (Container)model;
                return switch (cont.getType()) {
                    case 5 -> new DocumentPart(cont);
                    case 3 -> new ImportsPart(cont);
                    case 2, 4 -> new BlockTextPart(cont);
                    case 6 -> new InlineTextPart(cont);
                    default -> throw new RuntimeException("unknown model type");
                };
            }
            if (model instanceof TextRun) {
                TextRun textRun = (TextRun)model;
                if (textRun.getType() == 1) {
                    return new ImportPart(textRun);
                }
                return new TextFlowPart(textRun);
            }
            throw new RuntimeException("unexpected model object");
        }
    }

    class TextOutlinePage
    extends ContentOutlinePage {
        public TextOutlinePage(EditPartViewer viewer) {
            super((EditPartViewer)new TreeViewer());
            DefaultEditDomain domain = new DefaultEditDomain((IEditorPart)TextEditor.this);
            domain.setDefaultTool((Tool)new SelectionTool());
            domain.loadDefaultTool();
            EditPartViewer treeViewer = this.getViewer();
            treeViewer.setEditDomain((EditDomain)domain);
            TextEditor.this.getSelectionSynchronizer().addViewer(treeViewer);
            treeViewer.setEditPartFactory((context, model) -> {
                if (model instanceof Container) {
                    Container cont = (Container)model;
                    return new ContainerTreePart(cont);
                }
                return new TextRunTreePart(model);
            });
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.getViewer().setContents((Object)TextEditor.this.doc);
        }
    }
}

