/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.requests;

import org.eclipse.gef.Request;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.SelectionRange;

public class TextRequest
extends Request {
    public static final Object REQ_BACKSPACE = new Object();
    public static final Object REQ_BREAK = new Object();
    public static final Object REQ_DELETE = new Object();
    public static final Object REQ_INDENT = new Object();
    public static final Object REQ_INSERT = new Object();
    public static final Object REQ_OVERWRITE = new Object();
    public static final Object REQ_STYLE = new Object();
    public static final Object REQ_NEW_PAGE = new Object();
    public static final Object REQ_NEWLINE = new Object();
    public static final Object REQ_REMOVE_RANGE = new Object();
    public static final Object REQ_UNINDENT = new Object();
    private final AppendableCommand previous;
    private final SelectionRange range;
    private final String text;
    private String[] styleKeys;
    private Object[] styleValues;

    public TextRequest(SelectionRange range, String text, AppendableCommand previous) {
        this(REQ_INSERT, range, text, previous);
    }

    public TextRequest(Object type, SelectionRange range) {
        this(type, range, null, null);
    }

    public TextRequest(Object type, SelectionRange range, AppendableCommand previous) {
        this(type, range, null, previous);
    }

    public TextRequest(Object type, SelectionRange range, String text, AppendableCommand previous) {
        super(type == null ? REQ_INSERT : type);
        this.text = text;
        this.range = range;
        this.previous = previous;
    }

    public int getInsertionOffset() {
        return this.range.begin.offset;
    }

    public AppendableCommand getPreviousCommand() {
        return this.previous;
    }

    public SelectionRange getSelectionRange() {
        return this.range;
    }

    public String[] getStyleKeys() {
        return this.styleKeys;
    }

    public Object[] getStyleValues() {
        return this.styleValues;
    }

    public String getText() {
        return this.text;
    }

    public void setStyles(String[] keys, Object[] values) {
        this.styleKeys = keys;
        this.styleValues = values;
    }
}

