/*******************************************************************************
 * Copyright (c) 2005, 2023 IBM Corporation and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShellTestor {

	static int x, y;

	public static void main(String[] args) {
		Display d = Display.getDefault();
		final Shell shell = new Shell(d, SWT.H_SCROLL | SWT.V_SCROLL | SWT.DIALOG_TRIM);

		Text text = new Text(shell, SWT.BORDER);
		text.setBounds(100, 10, 80, 23);
		text.setText("foobar"); //$NON-NLS-1$

		shell.getVerticalBar().addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				int dy = shell.getVerticalBar().getSelection() - y;
				shell.scroll(0, 0, x, dy, 200, 200, true);
				y = shell.getVerticalBar().getSelection();
			}
		});

		shell.setSize(600, 500);
		shell.open();
		while (!shell.isDisposed()) {
			while (!d.readAndDispatch()) {
				d.sleep();
			}
		}

	}

}
