/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class MergeWithPrevious
extends MiniEdit {
    private final int index;
    private final Container container;
    private final TextRun run;

    public MergeWithPrevious(TextEditPart part) {
        this.run = (TextRun)part.getModel();
        this.container = this.run.getContainer();
        this.index = this.container.getChildren().indexOf(this.run);
    }

    private TextRun getPreviousTextRun() {
        ModelElement candidate = this.container.getChildren().get(this.index - 1);
        while (candidate instanceof Container) {
            Container cont = (Container)candidate;
            candidate = cont.getChildren().get(cont.size() - 1);
        }
        return (TextRun)candidate;
    }

    @Override
    public void apply() {
        this.container.remove(this.run);
        TextRun previous = this.getPreviousTextRun();
        previous.insertText(this.run.getText(), previous.size());
    }

    @Override
    public boolean canApply() {
        return this.index > 0;
    }

    @Override
    public ModelLocation getResultingLocation() {
        TextRun previous = this.getPreviousTextRun();
        return new ModelLocation(previous, previous.size() - this.run.size());
    }

    @Override
    public void rollback() {
        throw new RuntimeException("not implemented");
    }
}

