/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.rect.Rect;
import org.eclipse.gef.dot.internal.ui.Dot2ZestAttributesConverter;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.GraphCopier;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.ZestProperties;

public class Dot2ZestGraphCopier
extends GraphCopier {
    private List<Node> clusterNodes;

    public Dot2ZestGraphCopier() {
        this(new Dot2ZestAttributesConverter());
        this.clusterNodes = new LinkedList<Node>();
    }

    public Dot2ZestGraphCopier(Dot2ZestAttributesConverter dot2ZestAttributesConverter) {
        super((IAttributeCopier)dot2ZestAttributesConverter);
    }

    public Dot2ZestAttributesConverter getAttributeCopier() {
        return (Dot2ZestAttributesConverter)super.getAttributeCopier();
    }

    public Graph copy(Graph dotGraph) {
        Graph zestGraph = super.copy(dotGraph);
        this.clusterNodes.clear();
        ArrayList<Node> zestNodeReplacements = new ArrayList<Node>();
        for (Node zestNode : zestGraph.getNodes()) {
            this.processZestNode(zestNode, zestGraph, zestNodeReplacements);
        }
        zestNodeReplacements.addAll(0, this.clusterNodes);
        return new Graph((Map)zestGraph.attributesProperty(), zestNodeReplacements, (Collection)zestGraph.edgesProperty());
    }

    protected void processZestNode(Node zestNode, Graph zestGraph, List<Node> zestNodeReplacements) {
        if (zestNode.getNestedGraph() == null) {
            zestNodeReplacements.add(zestNode);
        } else {
            this.processNestedGraph(zestNode, zestGraph, zestNodeReplacements);
        }
    }

    protected void processNestedGraph(Node zestNode, Graph zestGraph, List<Node> zestNodeReplacements) {
        Node dotNode = this.getDotNode(zestNode);
        if (DotAttributes.isCluster((Node)dotNode) && !this.getAttributeCopier().options().emulateLayout) {
            this.processCluster(dotNode, zestNode);
        }
        this.processSubgraph(zestNode, zestGraph, zestNodeReplacements);
        for (Node nestedNode : zestNode.getNestedGraph().getNodes()) {
            this.processZestNode(nestedNode, zestGraph, zestNodeReplacements);
        }
        zestNode.setNestedGraph(null);
    }

    protected void processCluster(Node dotNode, Node zestNode) {
        String dotLabel;
        this.clusterNodes.add(zestNode);
        ZestProperties.setShape((Node)zestNode, (javafx.scene.Node)new GeometryNode((IGeometry)new Rectangle()));
        Rect bb = DotAttributes.getBbParsed((Graph)dotNode.getNestedGraph());
        Point zestPosition = null;
        Dimension zestSize = null;
        if (bb != null) {
            zestPosition = new Point(bb.getLlx(), bb.getUry());
            zestSize = new Dimension(bb.getUrx() - bb.getLlx(), bb.getLly() - bb.getUry());
            ZestProperties.setPosition((Node)zestNode, (Point)zestPosition);
            ZestProperties.setSize((Node)zestNode, (Dimension)zestSize);
        }
        if ("\\G".equals(dotLabel = DotAttributes.getLabel((Graph)dotNode.getNestedGraph()))) {
            dotLabel = DotAttributes._getName((Graph)dotNode.getNestedGraph());
        }
        if (dotLabel != null) {
            ZestProperties.setExternalLabel((Node)zestNode, (String)dotLabel);
            if (zestPosition != null && zestSize != null) {
                double xOffset = 0.5 * (zestSize.width - Dot2ZestAttributesConverter.computeZestLabelSize((String)dotLabel).width);
                double yOffset = 4.0;
                ZestProperties.setExternalLabelPosition((Node)zestNode, (Point)zestPosition.getTranslated(xOffset, yOffset));
            }
        }
    }

    protected void processSubgraph(Node zestNode, Graph zestGraph, List<Node> zestNodeReplacements) {
        Graph subgraph = zestNode.getNestedGraph();
        for (Node n : subgraph.getNodes()) {
            Edge edgeCopy;
            for (Edge e : zestNode.getIncomingEdges()) {
                edgeCopy = this.copyEdge(e);
                edgeCopy.setTarget(n);
                zestGraph.getEdges().add((Object)edgeCopy);
            }
            for (Edge e : zestNode.getOutgoingEdges()) {
                edgeCopy = this.copyEdge(e);
                edgeCopy.setSource(n);
                zestGraph.getEdges().add((Object)edgeCopy);
            }
        }
        zestGraph.getEdges().addAll((Collection)subgraph.getEdges());
    }

    protected Node getDotNode(Node zestNode) {
        Map inputToOutputMap = this.getInputToOutputNodeMap();
        for (Node input : inputToOutputMap.keySet()) {
            Node output = (Node)inputToOutputMap.get(input);
            if (output != zestNode) continue;
            return input;
        }
        return null;
    }
}

