/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.editor;

import com.google.inject.Injector;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.DocumentPartitioner;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.Strings;

public class DotEditorUtils {
    public static boolean isDotEditor(Object object) {
        if (object instanceof XtextEditor) {
            XtextEditor editor = (XtextEditor)object;
            return "org.eclipse.gef.dot.internal.language.Dot".equals(editor.getLanguageName());
        }
        return false;
    }

    public static StyledString style(String format, Object ... args) {
        String text = String.format(format, args);
        StyledString styled = new StyledString(text);
        int offset = text.indexOf(58);
        styled.setStyle(offset, text.length() - offset, StyledString.DECORATIONS_STYLER);
        return styled;
    }

    public static IXtextDocument getDocument(Injector injector, String currentModelToParse) throws Exception {
        XtextResource xtextResource = DotEditorUtils.getXtextResource(injector, currentModelToParse);
        return DotEditorUtils.getDocument(injector, xtextResource, currentModelToParse);
    }

    public static XtextResource getXtextResource(Injector injector, String currentModelToParse) {
        XtextResource xtextResource = null;
        try {
            xtextResource = DotEditorUtils.doGetResource(injector, (InputStream)new StringInputStream(Strings.emptyIfNull((String)currentModelToParse)), URI.createURI((String)""));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xtextResource;
    }

    private static IXtextDocument getDocument(Injector injector, XtextResource xtextResource, String model) {
        XtextDocument document = (XtextDocument)injector.getInstance(XtextDocument.class);
        document.set(model);
        document.setInput(xtextResource);
        DocumentPartitioner partitioner = (DocumentPartitioner)injector.getInstance(DocumentPartitioner.class);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    private static XtextResource doGetResource(Injector injector, InputStream in, URI uri) throws Exception {
        XtextResourceSet rs = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        rs.setClasspathURIContext(DotEditorUtils.class);
        XtextResource resource = (XtextResource)((IResourceFactory)injector.getInstance(IResourceFactory.class)).createResource(uri);
        rs.getResources().add((Object)resource);
        resource.load(in, null);
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(CancelIndicator.NullImpl);
        } else {
            EcoreUtil.resolveAll((Resource)resource);
        }
        return resource;
    }
}

