/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class DotExport {
    public String exportDot(Graph graph) {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Graph[]{graph});
        return this.exportDot(_newArrayList);
    }

    public String exportDot(List<Graph> graphs) {
        String _xblockexpression = null;
        StringBuilder builder = new StringBuilder();
        for (Graph graph : graphs) {
            Functions.Function1<Node, Boolean> _function_1;
            Functions.Function1<Node, Boolean> _function;
            boolean _tripleEquals;
            GraphType _type = this.type(graph);
            boolean bl = _tripleEquals = _type == null;
            if (_tripleEquals) {
                throw new IllegalArgumentException("The _type attribute has to be set on the input graph " + graph + ".");
            }
            ObservableList _nodes = graph.getNodes();
            Iterable _filter = IterableExtensions.filter((Iterable)_nodes, (Functions.Function1)(_function = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    Graph _nestedGraph = it.getNestedGraph();
                    return _nestedGraph == null;
                }
            }));
            boolean _exists = IterableExtensions.exists((Iterable)_filter, (Functions.Function1)(_function_1 = new Functions.Function1<Node, Boolean>(){

                public Boolean apply(Node it) {
                    boolean _hasName = DotExport.this.hasName((IAttributeStore)it);
                    return !_hasName;
                }
            }));
            if (_exists) {
                throw new IllegalArgumentException("The _name attribute has to be set for all nodes of the input graph " + graph + ".");
            }
            String _print = this.print(graph);
            builder.append(_print);
        }
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    public File exportDot(Graph graph, String pathname) {
        String _exportDot = this.exportDot(graph);
        File _file = new File(pathname);
        return DotFileUtils.write(_exportDot, _file);
    }

    public File exportDot(List<Graph> graphs, String pathname) {
        String _exportDot = this.exportDot(graphs);
        File _file = new File(pathname);
        return DotFileUtils.write(_exportDot, _file);
    }

    private String print(Graph it) {
        StringConcatenation _builder = new StringConcatenation();
        GraphType _type = this.type(it);
        _builder.append((Object)_type, "");
        _builder.append((Object)" ");
        boolean _hasName = this.hasName((IAttributeStore)it);
        if (_hasName) {
            String _name = this.name((IAttributeStore)it);
            _builder.append((Object)_name, "");
            _builder.append((Object)" ");
        }
        _builder.append((Object)"{");
        _builder.newLineIfNotEmpty();
        boolean _hasNonMetaAttributes = this.hasNonMetaAttributes((IAttributeStore)it);
        if (_hasNonMetaAttributes) {
            _builder.append((Object)"\t");
            String _printNonMetaAttributes = this.printNonMetaAttributes((IAttributeStore)it, ";");
            _builder.append((Object)_printNonMetaAttributes, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        ObservableList _nodes = it.getNodes();
        Functions.Function1<Node, String> _function = new Functions.Function1<Node, String>(){

            public String apply(Node it) {
                return DotExport.this.print(it);
            }
        };
        List _map = ListExtensions.map((List)_nodes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"; ");
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        ObservableList _edges = it.getEdges();
        for (Edge edge : _edges) {
            _builder.append((Object)"\t");
            String _name_1 = this.name((IAttributeStore)edge);
            _builder.append((Object)_name_1, "\t");
            boolean _hasNonMetaAttributes_1 = this.hasNonMetaAttributes((IAttributeStore)edge);
            if (_hasNonMetaAttributes_1) {
                _builder.append((Object)" [");
                String _printNonMetaAttributes_1 = this.printNonMetaAttributes((IAttributeStore)edge, ",");
                _builder.append((Object)_printNonMetaAttributes_1, "\t");
                _builder.append((Object)"]");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private boolean isMetaAttribute(String it) {
        return it.startsWith("_");
    }

    private String print(Node it) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        Graph _nestedGraph = it.getNestedGraph();
        boolean bl = _tripleNotEquals = _nestedGraph != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"subgraph ");
            Graph _nestedGraph_1 = it.getNestedGraph();
            boolean _hasName = this.hasName((IAttributeStore)_nestedGraph_1);
            if (_hasName) {
                Graph _nestedGraph_2 = it.getNestedGraph();
                String _name = this.name((IAttributeStore)_nestedGraph_2);
                _builder.append((Object)_name, "");
                _builder.append((Object)" ");
            }
            _builder.append((Object)"{");
            _builder.newLineIfNotEmpty();
            Graph _nestedGraph_3 = it.getNestedGraph();
            boolean _hasNonMetaAttributes = this.hasNonMetaAttributes((IAttributeStore)_nestedGraph_3);
            if (_hasNonMetaAttributes) {
                _builder.append((Object)"\t");
                Graph _nestedGraph_4 = it.getNestedGraph();
                String _printNonMetaAttributes = this.printNonMetaAttributes((IAttributeStore)_nestedGraph_4, ";");
                _builder.append((Object)_printNonMetaAttributes, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            Graph _nestedGraph_5 = it.getNestedGraph();
            ObservableList _nodes = _nestedGraph_5.getNodes();
            Functions.Function1<Node, String> _function = new Functions.Function1<Node, String>(){

                public String apply(Node it) {
                    return DotExport.this.print(it);
                }
            };
            List _map = ListExtensions.map((List)_nodes, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)"; ");
            _builder.append((Object)_join, "\t");
            _builder.newLineIfNotEmpty();
            Graph _nestedGraph_6 = it.getNestedGraph();
            ObservableList _edges = _nestedGraph_6.getEdges();
            for (Edge edge : _edges) {
                _builder.append((Object)"\t");
                String _name_1 = this.name((IAttributeStore)edge);
                _builder.append((Object)_name_1, "\t");
                boolean _hasNonMetaAttributes_1 = this.hasNonMetaAttributes((IAttributeStore)edge);
                if (_hasNonMetaAttributes_1) {
                    _builder.append((Object)" [");
                    String _printNonMetaAttributes_1 = this.printNonMetaAttributes((IAttributeStore)edge, ",");
                    _builder.append((Object)_printNonMetaAttributes_1, "\t");
                    _builder.append((Object)"]");
                }
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _xifexpression = _builder.toString();
        } else {
            String _name_2 = this.name((IAttributeStore)it);
            String _xifexpression_1 = null;
            boolean _hasNonMetaAttributes_2 = this.hasNonMetaAttributes((IAttributeStore)it);
            if (_hasNonMetaAttributes_2) {
                String _printNonMetaAttributes_2 = this.printNonMetaAttributes((IAttributeStore)it, ",");
                String _plus = " [" + _printNonMetaAttributes_2;
                _xifexpression_1 = String.valueOf(_plus) + "]";
            } else {
                _xifexpression_1 = "";
            }
            _xifexpression = String.valueOf(_name_2) + _xifexpression_1;
        }
        return _xifexpression;
    }

    private boolean hasName(IAttributeStore it) {
        ObservableMap _attributes = it.getAttributes();
        Object _get = _attributes.get((Object)"_name");
        return _get != null;
    }

    private GraphType type(Graph it) {
        return DotAttributes._getType(it);
    }

    private String _name(IAttributeStore it) {
        ObservableMap _attributes = it.getAttributes();
        Object _get = _attributes.get((Object)"_name");
        return ((ID)_get).toValue();
    }

    private String _name(Edge it) {
        return DotAttributes._getName(it);
    }

    private boolean hasNonMetaAttributes(IAttributeStore it) {
        ObservableMap _attributes = it.getAttributes();
        Set _keySet = _attributes.keySet();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isMetaAttribute = DotExport.this.isMetaAttribute(it);
                return !_isMetaAttribute;
            }
        };
        return IterableExtensions.exists((Iterable)_keySet, (Functions.Function1)_function);
    }

    private String printNonMetaAttributes(IAttributeStore it, String separator) {
        ObservableMap _attributes = it.getAttributes();
        Set _entrySet = _attributes.entrySet();
        Functions.Function1<Map.Entry<String, Object>, Boolean> _function = new Functions.Function1<Map.Entry<String, Object>, Boolean>(){

            public Boolean apply(Map.Entry<String, Object> it) {
                String _key = it.getKey();
                boolean _isMetaAttribute = DotExport.this.isMetaAttribute(_key);
                return !_isMetaAttribute;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_entrySet, (Functions.Function1)_function);
        Functions.Function1<Map.Entry<String, Object>, String> _function_1 = new Functions.Function1<Map.Entry<String, Object>, String>(){

            public String apply(Map.Entry<String, Object> it) {
                String _key = it.getKey();
                String _plus = String.valueOf(_key) + "=";
                Object _value = it.getValue();
                String _string = _value.toString();
                return String.valueOf(_plus) + _string;
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        List _sort = IterableExtensions.sort((Iterable)_map);
        return IterableExtensions.join((Iterable)_sort, (CharSequence)(String.valueOf(separator) + " "));
    }

    private String name(IAttributeStore it) {
        if (it instanceof Edge) {
            return this._name((Edge)it);
        }
        if (it != null) {
            return this._name(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

