/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.layout.algorithms;

import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.layout.LayoutProperties;
import org.eclipse.gef.layout.algorithms.AlgorithmHelper;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;

public class RadialLayoutAlgorithm
implements ILayoutAlgorithm {
    private static final double MAX_DEGREES = Math.PI * 2;
    private double startDegree = 0.0;
    private double endDegree = Math.PI * 2;
    private boolean resize = false;
    private TreeLayoutAlgorithm treeLayout = new TreeLayoutAlgorithm();

    @Override
    public void applyLayout(LayoutContext layoutContext, boolean clean) {
        if (!clean) {
            return;
        }
        this.treeLayout.internalApplyLayout(layoutContext);
        Node[] entities = layoutContext.getNodes();
        Rectangle bounds = LayoutProperties.getBounds(layoutContext.getGraph()).getCopy();
        this.computeRadialPositions(entities, bounds);
        if (this.resize) {
            AlgorithmHelper.maximizeSizes(entities);
        }
        int insets = 4;
        bounds.setX(bounds.getX() + (double)insets);
        bounds.setY(bounds.getY() + (double)insets);
        bounds.setWidth(bounds.getWidth() - (double)(2 * insets));
        bounds.setHeight(bounds.getHeight() - (double)(2 * insets));
        AlgorithmHelper.fitWithinBounds(entities, bounds, this.resize);
    }

    private void computeRadialPositions(Node[] entities, Rectangle bounds) {
        Rectangle layoutBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        layoutBounds.setX(bounds.getX());
        layoutBounds.setWidth(bounds.getWidth());
        int i = 0;
        while (i < entities.length) {
            Point location = LayoutProperties.getLocation(entities[i]);
            if (layoutBounds.getWidth() == 0.0 || layoutBounds.getHeight() == 0.0) {
                location.x = 0.0;
                location.y = 0.0;
            } else {
                double percenttheta = (location.x - layoutBounds.getX()) / layoutBounds.getWidth();
                double distance = (location.y - layoutBounds.getY()) / layoutBounds.getHeight();
                double theta = this.startDegree + Math.abs(this.endDegree - this.startDegree) * percenttheta;
                location.x = distance * Math.cos(theta);
                location.y = distance * Math.sin(theta);
            }
            LayoutProperties.setLocation(entities[i], location);
            ++i;
        }
    }

    public void setRangeToLayout(double startDegree, double endDegree) {
        this.startDegree = startDegree;
        this.endDegree = endDegree;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
        this.treeLayout.setResizing(this.resize);
    }
}

