/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.parts;

import java.util.Set;
import javafx.scene.Node;
import org.eclipse.gef.common.collections.SetMultimapChangeListener;
import org.eclipse.gef.mvc.fx.parts.AbstractHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractLogoHoverHandlePart<T extends Node>
extends AbstractHandlePart<T> {
    private boolean registered = false;
    private final SetMultimapChangeListener<IVisualPart<? extends Node>, String> parentAnchoragesChangeListener = new SetMultimapChangeListener<IVisualPart<? extends Node>, String>(){

        private IViewer getViewer(Set<? extends IVisualPart<? extends Node>> anchorages) {
            for (IVisualPart<? extends Node> iVisualPart : anchorages) {
                if (iVisualPart.getRoot() == null || iVisualPart.getRoot().getViewer() == null) continue;
                return iVisualPart.getRoot().getViewer();
            }
            return null;
        }

        public void onChanged(SetMultimapChangeListener.Change<? extends IVisualPart<? extends Node>, ? extends String> change) {
            IViewer oldViewer = this.getViewer(change.getPreviousContents().keySet());
            IViewer newViewer = this.getViewer(change.getSetMultimap().keySet());
            if (AbstractLogoHoverHandlePart.this.registered && oldViewer != null && oldViewer != newViewer) {
                oldViewer.unsetAdapter((Object)AbstractLogoHoverHandlePart.this);
            }
            if (!AbstractLogoHoverHandlePart.this.registered && newViewer != null && oldViewer != newViewer) {
                newViewer.setAdapter((Object)AbstractLogoHoverHandlePart.this, String.valueOf(System.identityHashCode((Object)AbstractLogoHoverHandlePart.this)));
            }
        }
    };

    protected void doRefreshVisual(T visual) {
    }

    protected void register(IViewer viewer) {
        if (this.registered) {
            return;
        }
        super.register(viewer);
        this.registered = true;
    }

    public void setParent(IVisualPart<? extends Node> newParent) {
        if (this.getParent() != null) {
            this.getParent().getAnchoragesUnmodifiable().removeListener(this.parentAnchoragesChangeListener);
        }
        if (newParent != null) {
            newParent.getAnchoragesUnmodifiable().addListener(this.parentAnchoragesChangeListener);
        }
        super.setParent(newParent);
    }

    protected void unregister(IViewer viewer) {
        if (!this.registered) {
            return;
        }
        super.unregister(viewer);
        this.registered = false;
    }
}

