/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.TransformContentOperation;
import org.eclipse.gef.mvc.fx.operations.TransformVisualOperation;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;

public class TransformPolicy
extends AbstractPolicy {
    private AffineTransform initialTransform;
    private List<AffineTransform> preTransforms = new ArrayList<AffineTransform>();
    private List<AffineTransform> postTransforms = new ArrayList<AffineTransform>();

    protected void applyTransform(AffineTransform finalTransform) {
        this.updateTransformOperation(finalTransform);
        this.locallyExecuteOperation();
    }

    @Override
    public ITransactionalOperation commit() {
        ITransactionalOperation commitOperation = super.commit();
        if (commitOperation != null && !commitOperation.isNoOp() && this.isContentTransformable()) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Transform Content");
            composite.add(commitOperation);
            composite.add(this.createTransformContentOperation());
            commitOperation = composite;
        }
        this.preTransforms.clear();
        this.postTransforms.clear();
        this.initialTransform = null;
        return commitOperation;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new TransformVisualOperation((ITransformableContentPart<? extends Node>)this.getHost());
    }

    public int createPostTransform() {
        this.checkInitialized();
        this.postTransforms.add(new AffineTransform());
        return this.postTransforms.size() - 1;
    }

    public int createPreTransform() {
        this.checkInitialized();
        this.preTransforms.add(new AffineTransform());
        return this.preTransforms.size() - 1;
    }

    protected ITransactionalOperation createTransformContentOperation() {
        return new TransformContentOperation((ITransformableContentPart<? extends Node>)this.getHost(), this.getCurrentTransform());
    }

    public AffineTransform getCurrentTransform() {
        return FX2Geometry.toAffineTransform((Transform)this.getHost().getVisualTransform());
    }

    public ITransformableContentPart<? extends Node> getHost() {
        return (ITransformableContentPart)super.getHost();
    }

    public AffineTransform getInitialTransform() {
        return this.initialTransform;
    }

    @Override
    public void init() {
        this.preTransforms.clear();
        this.postTransforms.clear();
        this.initialTransform = this.getCurrentTransform();
        super.init();
    }

    protected boolean isContentTransformable() {
        return this.getHost() instanceof ITransformableContentPart;
    }

    public void setPostRotate(int index, Angle rotation) {
        this.checkInitialized();
        this.postTransforms.get(index).setToRotation(rotation.rad());
        this.updateTransform();
    }

    public void setPostScale(int index, double sx, double sy) {
        this.checkInitialized();
        this.postTransforms.get(index).setToScale(sx, sy);
        this.updateTransform();
    }

    public void setPostTransform(int postTransformIndex, AffineTransform transform) {
        this.checkInitialized();
        this.postTransforms.get(postTransformIndex).setTransform(transform);
        this.updateTransform();
    }

    public void setPostTranslate(int index, double tx, double ty) {
        this.checkInitialized();
        this.postTransforms.get(index).setToTranslation(tx, ty);
        this.updateTransform();
    }

    public void setPreRotate(int index, Angle rotation) {
        this.checkInitialized();
        this.preTransforms.get(index).setToRotation(rotation.rad());
        this.updateTransform();
    }

    public void setPreScale(int index, double sx, double sy) {
        this.checkInitialized();
        this.preTransforms.get(index).setToScale(sx, sy);
        this.updateTransform();
    }

    public void setPreTransform(int preTransformIndex, AffineTransform transform) {
        this.checkInitialized();
        this.preTransforms.get(preTransformIndex).setTransform(transform);
        this.updateTransform();
    }

    public void setPreTranslate(int index, double tx, double ty) {
        this.checkInitialized();
        this.preTransforms.get(index).setToTranslation(tx, ty);
        this.updateTransform();
    }

    public void setTransform(AffineTransform finalTransform) {
        this.checkInitialized();
        this.preTransforms.clear();
        this.postTransforms.clear();
        this.applyTransform(finalTransform);
    }

    protected void updateTransform() {
        AffineTransform composite = new AffineTransform();
        int i = this.postTransforms.size() - 1;
        while (i >= 0) {
            composite.concatenate(this.postTransforms.get(i));
            --i;
        }
        composite.concatenate(this.initialTransform);
        for (AffineTransform pre : this.preTransforms) {
            composite.concatenate(pre);
        }
        this.applyTransform(composite);
    }

    protected void updateTransformOperation(AffineTransform newTransform) {
        ((TransformVisualOperation)this.getOperation()).setFinalTransform(Geometry2FX.toFXAffine((AffineTransform)newTransform));
    }
}

