/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.planar;

import java.util.ArrayList;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.planar.AbstractRectangleBasedGeometry;
import org.eclipse.gef.geometry.planar.CubicCurve;
import org.eclipse.gef.geometry.planar.CurveUtils;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.ShapeUtils;

abstract class AbstractArcBasedGeometry<T extends AbstractArcBasedGeometry<?, ?>, S extends IGeometry>
extends AbstractRectangleBasedGeometry<T, S> {
    private static final long serialVersionUID = 1L;
    protected Angle startAngle;
    protected Angle angularExtent;

    public AbstractArcBasedGeometry(double x, double y, double width, double height, Angle startAngle, Angle angularExtent) {
        super(x, y, width, height);
        this.startAngle = startAngle;
        this.angularExtent = angularExtent;
    }

    protected CubicCurve[] computeBezierApproximation() {
        double start = this.getStartAngle().rad();
        double end = this.getStartAngle().rad() + this.getAngularExtent().rad();
        ArrayList<CubicCurve> segments = new ArrayList<CubicCurve>();
        if (this.angularExtent.deg() <= 90.0) {
            segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start), Angle.fromRad(end)));
        } else {
            segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start), Angle.fromRad(start + 1.5707963267948966)));
            if (this.angularExtent.deg() <= 180.0) {
                segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start + 1.5707963267948966), Angle.fromRad(end)));
            } else {
                segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start + 1.5707963267948966), Angle.fromRad(start + Math.PI)));
                if (this.angularExtent.deg() <= 270.0) {
                    segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start + Math.PI), Angle.fromRad(end)));
                } else {
                    segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start + Math.PI), Angle.fromRad(start + 4.71238898038469)));
                    segments.add(ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromRad(start + 4.71238898038469), Angle.fromRad(end)));
                }
            }
        }
        return segments.toArray(new CubicCurve[0]);
    }

    public Angle getAngularExtent() {
        return this.angularExtent;
    }

    public Point getP1() {
        return this.getPoint(Angle.fromRad(0.0));
    }

    public Point getP2() {
        return this.getPoint(this.angularExtent);
    }

    public Point getPoint(Angle angularExtent) {
        double a = this.width / 2.0;
        double b = this.height / 2.0;
        return new Point(this.x + a + a * Math.cos(this.startAngle.rad() + angularExtent.rad()), this.y + b - b * Math.sin(this.startAngle.rad() + angularExtent.rad()));
    }

    public Angle getStartAngle() {
        return this.startAngle;
    }

    public double getX1() {
        return this.getP1().x;
    }

    public double getX2() {
        return this.getP2().x;
    }

    public double getY1() {
        return this.getP1().y;
    }

    public double getY2() {
        return this.getP2().y;
    }

    public T setAngularExtent(Angle angularExtent) {
        this.angularExtent = angularExtent;
        return (T)this;
    }

    public T setStartAngle(Angle startAngle) {
        this.startAngle = startAngle;
        return (T)this;
    }

    @Override
    public Path toPath() {
        return CurveUtils.toPath(this.computeBezierApproximation());
    }
}

