/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.examples.logo.model.GeometricShape;
import org.eclipse.gef.mvc.examples.logo.parts.GeometricShapePart;
import org.eclipse.gef.mvc.fx.gestures.ClickDragGesture;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.LayeredRootPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class CreateAndTranslateShapeOnDragHandler
extends AbstractHandler
implements IOnDragHandler {
    private GeometricShapePart createdShapePart;
    private Map<AdapterKey<? extends IOnDragHandler>, IOnDragHandler> dragPolicies;

    public void abortDrag() {
        if (this.createdShapePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.abortDrag();
            }
        }
        this.createdShapePart = null;
        this.dragPolicies = null;
    }

    public void drag(MouseEvent event, Dimension delta) {
        if (this.createdShapePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.drag(event, delta);
            }
        }
    }

    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.createdShapePart == null) {
            return;
        }
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.endDrag(e, delta);
            }
        }
        this.restoreRefreshVisuals((IVisualPart)this.createdShapePart);
        this.createdShapePart = null;
        this.dragPolicies = null;
    }

    protected IViewer getContentViewer() {
        return (IViewer)this.getHost().getRoot().getViewer().getDomain().getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
    }

    public GeometricShapePart getHost() {
        return (GeometricShapePart)super.getHost();
    }

    protected Point getLocation(MouseEvent e) {
        Point2D location = ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    public void hideIndicationCursor() {
    }

    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    public void startDrag(MouseEvent event) {
        IRootPart contentRoot = this.getContentViewer().getRootPart();
        GeometricShape copy = this.getHost().getContent().getCopy();
        Point2D localToScene = ((GeometryNode)this.getHost().getVisual()).localToScene(0.0, 0.0);
        Point2D originInModel = ((LayeredRootPart)this.getContentViewer().getRootPart()).getContentLayer().sceneToLocal(localToScene.getX(), localToScene.getY());
        double[] matrix = copy.getTransform().getMatrix();
        copy.getTransform().setTransform(matrix[0], matrix[1], matrix[2], matrix[3], originInModel.getX(), originInModel.getY());
        CreationPolicy creationPolicy = (CreationPolicy)contentRoot.getAdapter(CreationPolicy.class);
        this.init((IPolicy)creationPolicy);
        this.createdShapePart = (GeometricShapePart)creationPolicy.create((Object)copy, (IVisualPart)contentRoot, (SetMultimap)HashMultimap.create());
        this.commit((IPolicy)creationPolicy);
        this.storeAndDisableRefreshVisuals((IVisualPart)this.createdShapePart);
        ArrayList toBeDeselected = new ArrayList(((SelectionModel)this.getContentViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
        toBeDeselected.remove((Object)this.createdShapePart);
        DeselectOperation deselectOperation = new DeselectOperation(this.getContentViewer(), toBeDeselected);
        try {
            this.getHost().getRoot().getViewer().getDomain().execute((ITransactionalOperation)deselectOperation, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.dragPolicies = this.createdShapePart.getAdapters(ClickDragGesture.ON_DRAG_POLICY_KEY);
        if (this.dragPolicies != null) {
            for (IOnDragHandler dragPolicy : this.dragPolicies.values()) {
                dragPolicy.startDrag(event);
            }
        }
    }
}

