/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class SelectOperation
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Select";
    private IViewer viewer;
    private List<IContentPart<? extends Node>> initialSelection;
    private List<IContentPart<? extends Node>> toBeSelected;
    private List<IContentPart<? extends Node>> selected;

    public SelectOperation(IViewer viewer, List<? extends IContentPart<? extends Node>> toBeSelected) {
        this(DEFAULT_LABEL, viewer, toBeSelected);
    }

    public SelectOperation(String label, IViewer viewer, List<? extends IContentPart<? extends Node>> toBeSelected) {
        super(label);
        this.viewer = viewer;
        this.toBeSelected = new ArrayList<IContentPart<? extends Node>>(toBeSelected);
        SelectionModel selectionModel = this.getSelectionModel();
        this.initialSelection = new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = this.getSelectionModel();
        this.selected = new ArrayList<IContentPart<? extends Node>>(this.toBeSelected);
        this.selected.removeAll(new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable()));
        selectionModel.prependToSelection(this.selected);
        return Status.OK_STATUS;
    }

    protected SelectionModel getSelectionModel() {
        return (SelectionModel)((Object)this.viewer.getAdapter(SelectionModel.class));
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.initialSelection.containsAll(this.toBeSelected);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setSelection(this.initialSelection);
        return Status.OK_STATUS;
    }
}

