/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.examples.logo.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.mvc.examples.logo.handlers.AbstractCloneContentSupport;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnClickHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.ITransformableContentPart;
import org.eclipse.gef.mvc.fx.policies.CreationPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class CloneOnClickHandler
extends AbstractHandler
implements IOnClickHandler {
    public void click(MouseEvent event) {
        if (!this.isCloneModifierDown(event)) {
            return;
        }
        Object cloneContent = ((AbstractCloneContentSupport)((Object)this.getHost().getAdapter(AbstractCloneContentSupport.class))).cloneContent();
        IRootPart root = this.getHost().getRoot();
        CreationPolicy creationPolicy = (CreationPolicy)root.getAdapter(CreationPolicy.class);
        this.init((IPolicy)creationPolicy);
        IContentPart clonedContentPart = creationPolicy.create(cloneContent, this.getHost().getParent(), (SetMultimap)HashMultimap.create());
        this.commit((IPolicy)creationPolicy);
        if (clonedContentPart.getVisual() instanceof Connection) {
            Connection connection = (Connection)clonedContentPart.getVisual();
            if (connection.getStartAnchor() == null) {
                connection.setStartPoint(((Connection)this.getHost().getVisual()).getStartPoint());
            }
            if (connection.getEndAnchor() == null) {
                connection.setEndPoint(((Connection)this.getHost().getVisual()).getEndPoint());
            }
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        ArrayList toBeDeselected = new ArrayList(((SelectionModel)viewer.getAdapter(SelectionModel.class)).getSelectionUnmodifiable());
        toBeDeselected.remove(clonedContentPart);
        try {
            viewer.getDomain().execute((ITransactionalOperation)new DeselectOperation(this.getHost().getRoot().getViewer(), toBeDeselected), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (this.getHost() instanceof ITransformableContentPart) {
            ITransformableContentPart transformableContentPart = (ITransformableContentPart)this.getHost();
            Affine originalTransform = transformableContentPart.getVisualTransform();
            TransformPolicy transformPolicy = (TransformPolicy)clonedContentPart.getAdapter(TransformPolicy.class);
            this.init((IPolicy)transformPolicy);
            transformPolicy.setTransform(FX2Geometry.toAffineTransform((Transform)originalTransform));
            this.commit((IPolicy)transformPolicy);
        }
    }

    protected boolean isCloneModifierDown(MouseEvent e) {
        return e.isAltDown() || e.isShiftDown();
    }
}

