/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.examples;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Polyline;
import javafx.scene.text.Text;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;
import org.eclipse.gef.zest.examples.AbstractZestExample;
import org.eclipse.gef.zest.fx.ZestFxModule;
import org.eclipse.gef.zest.fx.parts.NodePart;
import org.eclipse.gef.zest.fx.parts.ZestFxContentPartFactory;

public class CustomNodeExample
extends AbstractZestExample {
    private static final String ATTR_CUSTOM = "isCustom";

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public CustomNodeExample() {
        super("GEF Zest - Custom Node Example");
    }

    @Override
    protected Graph createGraph() {
        Graph g = new Graph();
        CustomNodeExample.e(g, CustomNodeExample.n(g, new Object[]{"element-label", "A", ATTR_CUSTOM, true}), CustomNodeExample.n(g, new Object[]{"element-label", "B"}), new Object[0]);
        g.attributesProperty().put((Object)"graph-layout-algorithm", (Object)new SugiyamaLayoutAlgorithm());
        return g;
    }

    @Override
    protected Module createModule() {
        return new CustomModule();
    }

    public static class CustomContentPartFactory
    extends ZestFxContentPartFactory {
        @Inject
        private Injector injector;

        public IContentPart<? extends Node> createContentPart(Object content, Map<Object, Object> contextMap) {
            org.eclipse.gef.graph.Node n;
            Object isCustom;
            if (content instanceof org.eclipse.gef.graph.Node && (isCustom = (n = (org.eclipse.gef.graph.Node)content).attributesProperty().get((Object)CustomNodeExample.ATTR_CUSTOM)) instanceof Boolean && ((Boolean)isCustom).booleanValue()) {
                CustomNodeContentPart part = new CustomNodeContentPart();
                if (part != null) {
                    this.injector.injectMembers((Object)part);
                }
                return part;
            }
            return super.createContentPart(content, contextMap);
        }
    }

    public static class CustomModule
    extends ZestFxModule {
        protected void bindIContentPartFactory() {
            this.binder().bind(IContentPartFactory.class).toInstance((Object)new CustomContentPartFactory());
        }
    }

    public static class CustomNodeContentPart
    extends NodePart {
        private VBox vbox;
        private Text labelText;

        protected Group doCreateVisual() {
            ImageView ian = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("ibull.jpg").toExternalForm()));
            Polyline body = new Polyline(new double[]{0.0, 0.0, 0.0, 60.0, 25.0, 90.0, 0.0, 60.0, -25.0, 90.0, 0.0, 60.0, 0.0, 25.0, 25.0, 0.0, 0.0, 25.0, -25.0, 0.0});
            body.setTranslateX(ian.getLayoutBounds().getWidth() / 2.0 - body.getLayoutBounds().getWidth() / 2.0 - 5.0);
            body.setTranslateY(-15.0);
            this.labelText = new Text();
            this.vbox = new VBox();
            this.vbox.getChildren().addAll((Object[])new Node[]{ian, body, this.labelText});
            return new Group(new Node[]{this.vbox});
        }

        protected Text getLabelText() {
            return this.labelText;
        }
    }
}

