/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.cloudio.internal.ui.data;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.gef4.cloudio.internal.ui.data.Type;

public class TypeCollector {
    private static String stopWords;

    public static List<Type> getData(File file, String encoding) throws IOException {
        String s;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
        StringBuffer text = new StringBuffer();
        while ((s = br.readLine()) != null) {
            text.append(String.valueOf(s) + "\n");
        }
        br.close();
        HashSet<String> stops = new HashSet<String>();
        if (stopWords != null) {
            bis = new BufferedInputStream(new FileInputStream(stopWords));
            br = new BufferedReader(new InputStreamReader((InputStream)bis, encoding));
            while ((s = br.readLine()) != null) {
                stops.add(s.toLowerCase().trim());
            }
            br.close();
        }
        BreakIterator iterator = BreakIterator.getWordInstance(Locale.getDefault());
        String txt = text.toString();
        iterator.setText(txt);
        HashMap<String, Integer> strings = new HashMap<String, Integer>();
        int boundary = iterator.first();
        int lastBoundary = iterator.first();
        while (boundary != -1) {
            String string;
            boundary = iterator.next();
            if (boundary != -1 && (string = txt.substring(lastBoundary, boundary).trim()).length() != 0) {
                if (!Character.isLetter(string.charAt(string.length() - 1))) {
                    string = string.substring(0, string.length() - 1);
                }
                if (stops.contains(string.toLowerCase()) || string.trim().length() <= 1) {
                    lastBoundary = boundary;
                    continue;
                }
                Integer count = (Integer)strings.get(string);
                if (count == null) {
                    strings.put(string, 1);
                } else {
                    count = count + 1;
                    strings.put(string, count);
                }
            }
            lastBoundary = boundary;
        }
        return TypeCollector.getMostImportantTypes(strings);
    }

    private static List<Type> getMostImportantTypes(Map<String, Integer> strings) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Map.Entry<String, Integer> entry : strings.entrySet()) {
            Type type = new Type(entry.getKey(), entry.getValue());
            types.add(type);
        }
        ArrayList<Type> sorted = new ArrayList<Type>(types);
        Collections.sort(sorted, new Comparator<Type>(){

            @Override
            public int compare(Type o1, Type o2) {
                return o2.getOccurrences() - o1.getOccurrences();
            }
        });
        return sorted;
    }

    public static void setStopwords(String sourceFile) {
        stopWords = sourceFile;
    }
}

