/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.activate;

import java.beans.PropertyChangeSupport;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.IAdaptable;

public class ActivatableSupport {
    private boolean isActive = false;
    private IActivatable source;
    private PropertyChangeSupport pcs;

    public ActivatableSupport(IActivatable source, PropertyChangeSupport pcs) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null.");
        }
        if (pcs == null) {
            throw new IllegalArgumentException("pcs may not be null.");
        }
        this.source = source;
        this.pcs = pcs;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void activate() {
        if (!this.isActive) {
            this.isActive = true;
            this.pcs.firePropertyChange("active", false, true);
            this.activateAdapters();
        }
    }

    private void activateAdapters() {
        if (this.source instanceof IAdaptable) {
            for (IActivatable adapter : ((IAdaptable)((Object)this.source)).getAdapters(IActivatable.class).values()) {
                adapter.activate();
            }
        }
    }

    private void deactivateAdapters() {
        if (this.source instanceof IAdaptable) {
            for (IActivatable adapter : ((IAdaptable)((Object)this.source)).getAdapters(IActivatable.class).values()) {
                adapter.deactivate();
            }
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.deactivateAdapters();
            this.isActive = false;
            this.pcs.firePropertyChange("active", true, false);
        }
    }
}

