/*******************************************************************************
 * Copyright (c) 2014 itemis AG and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Matthias Wienand (itemis AG) - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.gef4.fx.nodes;

import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;

/**
 * The {@link FXPolyBezierConnectionRouter} interpolates a cubic Bezier spline
 * through the supplied {@link Point}s.
 *
 * @author mwienand
 *
 */
public class FXPolyBezierConnectionRouter implements IFXConnectionRouter {

	@Override
	public ICurve routeConnection(Point[] points) {
		if (points == null || points.length < 2) {
			return new Line(0, 0, 0, 0);
		}
		return PolyBezier.interpolateCubic(points);
	}

}
