/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.mvc.behaviors.HoverBehavior;
import org.eclipse.gef4.mvc.examples.logo.parts.FXCreateCurveHoverHandlePart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXDeleteHoverHandlePart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricShapePart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXHoverHandleRootPart;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultHandlePartFactory;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXBendOnSegmentHandleDragPolicy;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXLogoHandlePartFactory
extends FXDefaultHandlePartFactory {
    @Inject
    private Injector injector;

    public IHandlePart<Node, ? extends Node> createCurveSelectionHandlePart(IVisualPart<Node, ? extends Node> targetPart, Provider<BezierCurve[]> segmentsProvider, int segmentCount, int segmentIndex, double segmentParameter) {
        FXCircleSegmentHandlePart part = (FXCircleSegmentHandlePart)super.createCurveSelectionHandlePart(targetPart, segmentsProvider, segmentCount, segmentIndex, segmentParameter);
        this.injector.injectMembers((Object)part);
        if ((double)segmentIndex + segmentParameter > 0.0 && (double)segmentIndex + segmentParameter < (double)segmentCount) {
            part.setAdapter(AdapterKey.get(AbstractFXOnDragPolicy.class), (Object)new FXBendOnSegmentHandleDragPolicy());
        } else {
            part.setAdapter(AdapterKey.get(AbstractFXOnDragPolicy.class), (Object)new FXBendOnSegmentHandleDragPolicy());
        }
        return part;
    }

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandleParts(IVisualPart<Node, ? extends Node> target, HoverBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
        ArrayList<IHandlePart<Node, ? extends Node>> handles = new ArrayList<IHandlePart<Node, ? extends Node>>();
        if (target instanceof FXGeometricShapePart) {
            FXHoverHandleRootPart parentHp = new FXHoverHandleRootPart();
            this.injector.injectMembers((Object)parentHp);
            handles.add((IHandlePart<Node, ? extends Node>)parentHp);
            FXDeleteHoverHandlePart deleteHp = new FXDeleteHoverHandlePart();
            this.injector.injectMembers((Object)deleteHp);
            parentHp.addChild((IVisualPart)deleteHp);
            FXCreateCurveHoverHandlePart createCurveHp = new FXCreateCurveHoverHandlePart();
            this.injector.injectMembers((Object)createCurveHp);
            parentHp.addChild((IVisualPart)createCurveHp);
            return handles;
        }
        return super.createHoverHandleParts(target, contextBehavior, contextMap);
    }
}

