/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.common.collect.Multiset;
import java.util.Collections;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Paint;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricModel;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricCurvePart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricModelPart;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricShapePart;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnClickPolicy;
import org.eclipse.gef4.mvc.fx.tools.FXClickDragTool;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.CreationPolicy;

public class FXCreateCurveOnClickPolicy
extends AbstractFXOnClickPolicy {
    public void click(MouseEvent e) {
        FXGeometricCurve curve = new FXGeometricCurve(new Point[0], (Paint)FXGeometricModel.GEF_COLOR_GREEN, 3.5, FXGeometricModel.GEF_DASH_PATTERN, null);
        curve.addSourceAnchorage(this.getShapePart().getContent());
        CreationPolicy creationPolicy = (CreationPolicy)this.getHost().getRoot().getAdapter(CreationPolicy.class);
        creationPolicy.init();
        IVisualPart modelPart = (IVisualPart)this.getHost().getRoot().getChildren().get(0);
        if (!(modelPart instanceof FXGeometricModelPart)) {
            throw new IllegalStateException("Cannot find FXGeometricModelPart.");
        }
        creationPolicy.create((IContentPart)((FXGeometricModelPart)modelPart), (Object)curve);
        IUndoableOperation createOperation = creationPolicy.commit();
        this.getHost().getRoot().getViewer().getDomain().execute(createOperation);
        FXGeometricCurvePart curvePart = (FXGeometricCurvePart)this.getHost().getRoot().getViewer().getContentPartMap().get(curve);
        ((FXConnection)curvePart.getVisual()).setEndPoint(this.getLocation(e));
        this.updateDragTargetToLastSegmentHandlePart(curvePart, e.getTarget());
    }

    protected Point getLocation(MouseEvent e) {
        Point2D location = ((FXViewer)this.getHost().getRoot().getViewer()).getScrollPane().getContentGroup().sceneToLocal(e.getSceneX(), e.getSceneY());
        return new Point(location.getX(), location.getY());
    }

    protected FXGeometricShapePart getShapePart() {
        return (FXGeometricShapePart)this.getHost().getParent().getAnchorages().keySet().iterator().next();
    }

    protected void updateDragTargetToLastSegmentHandlePart(FXGeometricCurvePart curvePart, EventTarget eventTarget) {
        ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).deselectAll();
        ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).select(Collections.singletonList(curvePart));
        Multiset anchoreds = curvePart.getAnchoreds();
        FXCircleSegmentHandlePart lastSegmentHandlePart = null;
        for (IVisualPart anchored : anchoreds) {
            FXCircleSegmentHandlePart circleSegmentHandlePart;
            if (!(anchored instanceof FXCircleSegmentHandlePart) || (circleSegmentHandlePart = (FXCircleSegmentHandlePart)anchored).getSegmentParameter() != 1.0) continue;
            lastSegmentHandlePart = circleSegmentHandlePart;
            break;
        }
        ((FXClickDragTool)this.getHost().getRoot().getViewer().getDomain().getAdapter(FXClickDragTool.class)).overrideTargetForThisInteraction(eventTarget, lastSegmentHandlePart);
    }
}

