/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.fx.ui.controls.FXControlAdapter;
import org.eclipse.gef4.mvc.fx.ui.properties.AbstractFXColorPicker;
import org.eclipse.gef4.mvc.fx.ui.properties.FXColorPicker;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FXSimpleGradientPicker
implements IPropertyChangeNotifier {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private LinearGradient simpleGradient;
    private AbstractFXColorPicker color1Picker;
    private FXColorPicker color2Picker;
    private Control control;

    public FXSimpleGradientPicker(Composite parent) {
        this.control = this.createControl(parent);
        this.setSimpleGradient(FXSimpleGradientPicker.createSimpleGradient(Color.WHITE, Color.BLACK));
    }

    public Control getControl() {
        return this.control;
    }

    protected Control createControl(final Composite parent) {
        FXCanvas canvas = new FXCanvas(parent, 0);
        HBox root = new HBox();
        VBox colorEditorsBox = new VBox();
        root.getChildren().add((Object)colorEditorsBox);
        this.color1Picker = new AbstractFXColorPicker(){

            @Override
            public Color pickColor() {
                return FXColorPicker.pickColor(parent.getShell(), this.getColor());
            }
        };
        colorEditorsBox.getChildren().add((Object)this.color1Picker);
        this.color1Picker.colorProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                FXSimpleGradientPicker.this.setSimpleGradient(FXSimpleGradientPicker.createSimpleGradient(FXSimpleGradientPicker.this.color1Picker.getColor(), FXSimpleGradientPicker.this.color2Picker.getColor()));
            }
        });
        this.color2Picker = new FXColorPicker((Composite)canvas);
        FXControlAdapter color2EditorNode = new FXControlAdapter(this.color2Picker.getControl());
        colorEditorsBox.getChildren().add((Object)color2EditorNode);
        this.color2Picker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FXSimpleGradientPicker.this.setSimpleGradient(FXSimpleGradientPicker.createSimpleGradient(FXSimpleGradientPicker.this.color1Picker.getColor(), FXSimpleGradientPicker.this.color2Picker.getColor()));
            }
        });
        Scene scene = new Scene((Parent)root);
        canvas.setScene(scene);
        return canvas;
    }

    public void setSimpleGradient(LinearGradient simpleGradient) {
        if (!FXSimpleGradientPicker.isSimpleGradient((Paint)simpleGradient)) {
            throw new IllegalArgumentException("Given value '" + simpleGradient + "' is no simple gradient");
        }
        LinearGradient oldSimpleGradient = this.simpleGradient;
        this.simpleGradient = simpleGradient;
        List stops = simpleGradient.getStops();
        if (stops.size() != 2) {
            throw new IllegalArgumentException("A simple gradient may only contain two stops.");
        }
        if (!this.color1Picker.getColor().equals((Object)((Stop)stops.get(0)).getColor())) {
            this.color1Picker.setColor(((Stop)stops.get(0)).getColor());
        }
        if (!this.color2Picker.getColor().equals((Object)((Stop)stops.get(1)).getColor())) {
            this.color2Picker.setColor(((Stop)stops.get(1)).getColor());
        }
        this.pcs.firePropertyChange("simpleGradient", oldSimpleGradient, simpleGradient);
    }

    public LinearGradient getSimpleGradient() {
        return this.simpleGradient;
    }

    protected static LinearGradient createSimpleGradient(Color c1, Color c2) {
        Stop[] stops = new Stop[]{new Stop(0.0, c1), new Stop(1.0, c2)};
        return new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public static boolean isSimpleGradient(Paint paint) {
        if (paint instanceof LinearGradient) {
            return ((LinearGradient)paint).getStops().size() == 2;
        }
        return false;
    }
}

