/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.collect.SetMultimap;
import com.google.inject.Provider;
import javafx.scene.Node;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXHandlePart;

public abstract class AbstractFXSegmentHandlePart<N extends Node>
extends AbstractFXHandlePart<N>
implements Comparable<AbstractFXSegmentHandlePart<? extends Node>> {
    private final Provider<BezierCurve[]> segmentsProvider;
    private BezierCurve[] segments;
    private int segmentIndex = -1;
    private double segmentParameter = 0.0;

    public AbstractFXSegmentHandlePart(Provider<BezierCurve[]> segmentsProvider, int segmentIndex, double segmentParameter) {
        this.segmentsProvider = segmentsProvider;
        this.segmentIndex = segmentIndex;
        this.segmentParameter = segmentParameter;
    }

    @Override
    public int compareTo(AbstractFXSegmentHandlePart<? extends Node> o) {
        if (!this.getAnchorages().equals((Object)o.getAnchorages())) {
            throw new IllegalArgumentException("Can only compare FXSegmentHandleParts that are bound to the same anchorages.");
        }
        return (int)((double)(100 * this.getSegmentIndex()) + 10.0 * this.getSegmentParameter() - ((double)(100 * o.getSegmentIndex()) + 10.0 * o.getSegmentParameter()));
    }

    public void doRefreshVisual(N visual) {
        this.updateLocation(visual);
    }

    protected Point getPosition(BezierCurve segment) {
        return segment.get(this.segmentParameter);
    }

    public int getSegmentCount() {
        return this.segments == null ? 0 : this.segments.length;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public double getSegmentParameter() {
        return this.segmentParameter;
    }

    protected BezierCurve[] getSegmentsInScene() {
        return this.segments;
    }

    public void setSegmentIndex(int segmentIndex) {
        int oldSegmentIndex = this.segmentIndex;
        this.segmentIndex = segmentIndex;
        if (oldSegmentIndex != segmentIndex) {
            this.refreshVisual();
        }
    }

    public void setSegmentParameter(double segmentParameter) {
        double oldSegmentParameter = this.segmentParameter;
        this.segmentParameter = segmentParameter;
        if (oldSegmentParameter != segmentParameter) {
            this.refreshVisual();
        }
    }

    protected void updateLocation(N visual) {
        SetMultimap anchorages = this.getAnchorages();
        if (anchorages.keySet().size() < 1) {
            return;
        }
        this.segments = (BezierCurve[])this.segmentsProvider.get();
        if (this.segmentIndex < 0 || this.segmentIndex > this.segments.length - 1) {
            visual.setVisible(false);
        } else {
            visual.setVisible(true);
            BezierCurve segmentInParent = (BezierCurve)FXUtils.sceneToLocal((Node)visual.getParent(), (IGeometry)this.segments[this.segmentIndex]);
            Point positionInParent = this.getPosition(segmentInParent);
            visual.relocate(positionInParent.x + visual.getLayoutBounds().getMinX(), positionInParent.y + visual.getLayoutBounds().getMinY());
        }
    }
}

