/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.nodes.ScrollPaneEx;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.operations.FXChangeViewportOperation;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnScrollPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ViewportModel;

public class FXPanOnScrollPolicy
extends AbstractFXOnScrollPolicy {
    private static final int SAME_SCROLL_MILLIS = 100;
    private long lastMillis = 0L;
    private boolean stopped = false;

    protected void applyPanning(double dx, double dy) {
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        this.getHost().getRoot().getViewer().getDomain().execute((IUndoableOperation)new FXChangeViewportOperation(viewportModel, viewportModel.getTranslateX() + dx, viewportModel.getTranslateY() + dy));
    }

    protected Dimension computeDelta(ScrollEvent event) {
        double dx = event.getDeltaX();
        double dy = event.getDeltaY();
        if (this.isSwapDirection(event)) {
            double t = dx;
            dx = dy;
            dy = t;
        }
        return new Dimension(dx, dy);
    }

    protected boolean isSuitable(ScrollEvent event) {
        return !event.isAltDown() && !event.isControlDown() && !event.isMetaDown();
    }

    protected boolean isSwapDirection(ScrollEvent event) {
        return event.isShiftDown();
    }

    @Override
    public void scroll(ScrollEvent event) {
        if (!this.isSuitable(event)) {
            return;
        }
        long millis = System.currentTimeMillis();
        long deltaMillis = millis - this.lastMillis;
        this.lastMillis = millis;
        if (deltaMillis < 100L) {
            if (this.stopped) {
                return;
            }
        } else {
            this.stopped = false;
        }
        Dimension delta = this.computeDelta(event);
        this.stopped = this.stopAtContentBounds(delta);
        this.applyPanning(delta.width, delta.height);
    }

    private boolean stopAtContentBounds(Dimension delta) {
        ScrollPaneEx scrollPane = ((FXViewer)this.getHost().getRoot().getViewer()).getScrollPane();
        Bounds contentBounds = scrollPane.getBoundsInViewport((Node)scrollPane.getContentGroup());
        boolean stopped = false;
        if (contentBounds.getMinX() < 0.0 && contentBounds.getMinX() + delta.width >= 0.0) {
            delta.width = -contentBounds.getMinX();
            stopped = true;
        } else if (contentBounds.getMaxX() > scrollPane.getWidth() && contentBounds.getMaxX() + delta.width <= scrollPane.getWidth()) {
            delta.width = scrollPane.getWidth() - contentBounds.getMaxX();
            stopped = true;
        }
        if (contentBounds.getMinY() < 0.0 && contentBounds.getMinY() + delta.height >= 0.0) {
            delta.height = -contentBounds.getMinY();
            stopped = true;
        } else if (contentBounds.getMaxY() > scrollPane.getHeight() && contentBounds.getMaxY() + delta.height <= scrollPane.getHeight()) {
            delta.height = scrollPane.getHeight() - contentBounds.getMaxY();
            stopped = true;
        }
        return stopped;
    }
}

