/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnRotatePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXRotatePolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXRotateSelectedOnRotatePolicy
extends AbstractFXOnRotatePolicy {
    private Point pivotInScene;

    protected FXRotatePolicy getRotatePolicy(IVisualPart<Node, ? extends Node> part) {
        return (FXRotatePolicy)((Object)part.getAdapter(FXRotatePolicy.class));
    }

    protected List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).getSelected();
    }

    @Override
    public void rotate(RotateEvent e) {
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
        }
    }

    @Override
    public void rotationFinished(RotateEvent e) {
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
            FXRotatePolicy rotatePolicy = this.getRotatePolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (rotatePolicy == null) continue;
            this.getHost().getRoot().getViewer().getDomain().execute(rotatePolicy.commit());
        }
    }

    @Override
    public void rotationStarted(RotateEvent e) {
        Rectangle bounds = FXPartUtils.getUnionedVisualBoundsInScene(this.getTargetParts());
        this.pivotInScene = bounds == null ? null : bounds.getCenter();
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            FXRotatePolicy rotatePolicy = this.getRotatePolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (rotatePolicy == null) continue;
            rotatePolicy.init();
        }
    }

    private void updateOperation(RotateEvent e, IVisualPart<Node, ? extends Node> part) {
        Angle rotationAngle = Angle.fromDeg((double)e.getTotalAngle());
        FXRotatePolicy rotatePolicy = this.getRotatePolicy(part);
        if (rotatePolicy != null) {
            rotatePolicy.performRotation(rotationAngle, this.pivotInScene);
        }
    }
}

